/*
 * Decompiled with CFR 0.152.
 */
package mage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import mage.Emptiable;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.costs.Cost;
import mage.abilities.mana.conditional.ManaCondition;
import mage.constants.ManaType;
import mage.filter.Filter;
import mage.filter.FilterMana;
import mage.game.Game;

public class ConditionalMana
extends Mana
implements Serializable,
Emptiable {
    private List<Condition> conditions = new ArrayList<Condition>();
    protected String staticText = "Conditional mana.";
    private Filter.ComparisonScope scope = Filter.ComparisonScope.All;
    private UUID manaProducerId;
    private UUID manaProducerOriginalId;

    public ConditionalMana(Mana mana) {
        super(mana);
    }

    protected ConditionalMana(ConditionalMana conditionalMana) {
        super(conditionalMana);
        this.conditions.addAll(conditionalMana.conditions);
        this.scope = conditionalMana.scope;
        this.staticText = conditionalMana.staticText;
        this.manaProducerId = conditionalMana.manaProducerId;
        this.manaProducerOriginalId = conditionalMana.manaProducerOriginalId;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void setComparisonScope(Filter.ComparisonScope scope) {
        this.scope = scope;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public boolean apply(Ability ability, Game game, UUID manaProducerId, Cost costToPay) {
        if (this.conditions.isEmpty()) {
            throw new IllegalStateException("Conditional mana should contain at least one Condition");
        }
        for (Condition condition : this.conditions) {
            boolean applied;
            boolean bl = applied = condition instanceof ManaCondition ? ((ManaCondition)condition).apply(game, ability, manaProducerId, costToPay) : condition.apply(game, ability);
            if (!applied) {
                if (this.scope != Filter.ComparisonScope.All) continue;
                return false;
            }
            if (this.scope != Filter.ComparisonScope.Any) continue;
            return true;
        }
        return this.scope == Filter.ComparisonScope.All;
    }

    @Override
    public ConditionalMana copy() {
        return new ConditionalMana(this);
    }

    public String getDescription() {
        return this.staticText;
    }

    public void removeAll(FilterMana filter) {
        if (filter == null) {
            return;
        }
        if (filter.isBlack()) {
            this.black = 0;
        }
        if (filter.isBlue()) {
            this.blue = 0;
        }
        if (filter.isWhite()) {
            this.white = 0;
        }
        if (filter.isGreen()) {
            this.green = 0;
        }
        if (filter.isRed()) {
            this.red = 0;
        }
        if (filter.isColorless()) {
            this.colorless = 0;
        }
        if (filter.isGeneric()) {
            this.generic = 0;
        }
    }

    public UUID getManaProducerId() {
        return this.manaProducerId;
    }

    public void setManaProducerId(UUID manaProducerId) {
        this.manaProducerId = manaProducerId;
    }

    public UUID getManaProducerOriginalId() {
        return this.manaProducerOriginalId;
    }

    public void setManaProducerOriginalId(UUID manaProducerOriginalId) {
        this.manaProducerOriginalId = manaProducerOriginalId;
    }

    @Override
    public void clear(ManaType manaType) {
        switch (manaType) {
            case BLACK: {
                this.black = 0;
                break;
            }
            case BLUE: {
                this.blue = 0;
                break;
            }
            case GREEN: {
                this.green = 0;
                break;
            }
            case RED: {
                this.red = 0;
                break;
            }
            case WHITE: {
                this.white = 0;
                break;
            }
            case GENERIC: {
                this.generic = 0;
                break;
            }
            case COLORLESS: {
                this.colorless = 0;
            }
        }
    }

    @Override
    public void add(Mana mana) {
        if (mana instanceof ConditionalMana) {
            for (Condition condition : ((ConditionalMana)mana).getConditions()) {
                this.addCondition(condition);
            }
        }
        super.add(mana);
    }

    public String getConditionString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Condition condition : this.conditions) {
            sb.append('{');
            sb.append(condition.getManaText());
            sb.append('}');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void add(ManaType manaType, int amount) {
        switch (manaType) {
            case BLACK: {
                this.black += amount;
                break;
            }
            case BLUE: {
                this.blue += amount;
                break;
            }
            case GREEN: {
                this.green += amount;
                break;
            }
            case RED: {
                this.red += amount;
                break;
            }
            case WHITE: {
                this.white += amount;
                break;
            }
            case COLORLESS: {
                this.colorless += amount;
                break;
            }
            case GENERIC: {
                this.generic += amount;
            }
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.conditions, this.staticText, this.scope, this.manaProducerId, this.manaProducerOriginalId});
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ConditionalMana that = (ConditionalMana)o;
        if (!Objects.equals(this.staticText, that.staticText)) {
            return false;
        }
        if (!Objects.equals(this.manaProducerId, that.manaProducerId)) {
            return false;
        }
        if (!Objects.equals(this.manaProducerOriginalId, that.manaProducerOriginalId)) {
            return false;
        }
        if (!Objects.equals((Object)this.scope, (Object)that.scope)) {
            return false;
        }
        if (this.conditions == null || that.conditions == null || this.conditions.size() != that.conditions.size()) {
            return false;
        }
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (Objects.equals(this.conditions.get(i), that.conditions.get(i))) continue;
            return false;
        }
        return true;
    }
}

