/*
 * Decompiled with CFR 0.152.
 */
package mage;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import mage.MageInt;
import mage.MageItem;
import mage.ObjectColor;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.cards.Card;
import mage.cards.FrameStyle;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.events.ZoneChangeEvent;
import mage.util.Copyable;
import mage.util.SubTypes;

public interface MageObject
extends MageItem,
Serializable,
Copyable<MageObject> {
    public String getExpansionSetCode();

    public void setExpansionSetCode(String var1);

    public String getCardNumber();

    public void setCardNumber(String var1);

    public Integer getImageNumber();

    public void setImageNumber(Integer var1);

    public boolean getUsesVariousArt();

    public void setUsesVariousArt(boolean var1);

    public String getImageFileName();

    public void setImageFileName(String var1);

    public String getName();

    public String getIdName();

    public String getLogName();

    public void setName(String var1);

    default public List<CardType> getCardType() {
        return this.getCardType(null);
    }

    public List<CardType> getCardType(Game var1);

    public SubTypes getSubtype();

    public SubTypes getSubtype(Game var1);

    public boolean hasSubtype(SubType var1, Game var2);

    default public List<SuperType> getSuperType() {
        return this.getSuperType(null);
    }

    public List<SuperType> getSuperType(Game var1);

    public Abilities<Ability> getAbilities();

    default public Abilities<Ability> getInitAbilities() {
        return this.getAbilities();
    }

    public boolean hasAbility(Ability var1, Game var2);

    public ObjectColor getColor();

    public ObjectColor getColor(Game var1);

    public ObjectColor getFrameColor(Game var1);

    public FrameStyle getFrameStyle();

    public ManaCosts<ManaCost> getManaCost();

    public void setManaCost(ManaCosts<ManaCost> var1);

    default public List<String> getManaCostSymbols() {
        ArrayList<String> symbols = new ArrayList<String>();
        for (ManaCost cost : this.getManaCost()) {
            symbols.add(cost.getText());
        }
        return symbols;
    }

    public int getManaValue();

    public MageInt getPower();

    public MageInt getToughness();

    public int getStartingLoyalty();

    public void setStartingLoyalty(int var1);

    public int getStartingDefense();

    public void setStartingDefense(int var1);

    @Override
    public MageObject copy();

    public void setCopy(boolean var1, MageObject var2);

    public MageObject getCopyFrom();

    public boolean isCopy();

    public int getZoneChangeCounter(Game var1);

    public void updateZoneChangeCounter(Game var1, ZoneChangeEvent var2);

    public void setZoneChangeCounter(int var1, Game var2);

    default public boolean isHistoric(Game game) {
        return this.isArtifact(game) || this.isLegendary(game) || this.hasSubtype(SubType.SAGA, game);
    }

    default public boolean isOutlaw(Game game) {
        return this.hasSubtype(SubType.ASSASSIN, game) || this.hasSubtype(SubType.MERCENARY, game) || this.hasSubtype(SubType.PIRATE, game) || this.hasSubtype(SubType.ROGUE, game) || this.hasSubtype(SubType.WARLOCK, game);
    }

    default public boolean isCreature() {
        return this.isCreature(null);
    }

    default public boolean isCreature(Game game) {
        return this.getCardType(game).contains((Object)CardType.CREATURE);
    }

    default public boolean isArtifact() {
        return this.isArtifact(null);
    }

    default public boolean isArtifact(Game game) {
        return this.getCardType(game).contains((Object)CardType.ARTIFACT);
    }

    default public boolean isLand() {
        return this.isLand(null);
    }

    default public boolean isLand(Game game) {
        return this.getCardType(game).contains((Object)CardType.LAND);
    }

    default public boolean isEnchantment() {
        return this.isEnchantment(null);
    }

    default public boolean isEnchantment(Game game) {
        return this.getCardType(game).contains((Object)CardType.ENCHANTMENT);
    }

    default public boolean isInstant() {
        return this.isInstant(null);
    }

    default public boolean isInstant(Game game) {
        return this.getCardType(game).contains((Object)CardType.INSTANT);
    }

    default public boolean isSorcery() {
        return this.isSorcery(null);
    }

    default public boolean isSorcery(Game game) {
        return this.getCardType(game).contains((Object)CardType.SORCERY);
    }

    default public boolean isInstantOrSorcery() {
        return this.isInstant() || this.isSorcery();
    }

    default public boolean isInstantOrSorcery(Game game) {
        return this.isInstant(game) || this.isSorcery(game);
    }

    default public boolean isPlaneswalker() {
        return this.isPlaneswalker(null);
    }

    default public boolean isPlaneswalker(Game game) {
        return this.getCardType(game).contains((Object)CardType.PLANESWALKER);
    }

    default public boolean isKindred() {
        return this.isKindred(null);
    }

    default public boolean isKindred(Game game) {
        return this.getCardType(game).contains((Object)CardType.KINDRED);
    }

    default public boolean isBattle() {
        return this.isBattle(null);
    }

    default public boolean isBattle(Game game) {
        return this.getCardType(game).contains((Object)CardType.BATTLE);
    }

    default public boolean isPermanent() {
        return this.isCreature() || this.isArtifact() || this.isPlaneswalker() || this.isEnchantment() || this.isLand() || this.isBattle();
    }

    default public boolean isPermanent(Game game) {
        return this.isCreature(game) || this.isArtifact(game) || this.isPlaneswalker(game) || this.isEnchantment(game) || this.isLand(game) || this.isBattle(game);
    }

    default public boolean isLegendary() {
        return this.isLegendary(null);
    }

    default public boolean isLegendary(Game game) {
        return this.getSuperType(game).contains((Object)SuperType.LEGENDARY);
    }

    default public boolean isSnow() {
        return this.isSnow(null);
    }

    default public boolean isSnow(Game game) {
        return this.getSuperType(game).contains((Object)SuperType.SNOW);
    }

    default public boolean isBasic() {
        return this.isBasic(null);
    }

    default public boolean isBasic(Game game) {
        return this.getSuperType(game).contains((Object)SuperType.BASIC);
    }

    default public boolean isWorld() {
        return this.isWorld(null);
    }

    default public boolean isWorld(Game game) {
        return this.getSuperType(game).contains((Object)SuperType.WORLD);
    }

    default public void addSuperType(SuperType superType) {
        this.addSuperType(null, superType);
    }

    default public void addSuperType(Game game, SuperType superType) {
        List<SuperType> currentSuperTypes = game != null ? game.getState().getCreateMageObjectAttribute(this, game).getSuperType() : this.getSuperType();
        if (!currentSuperTypes.contains((Object)superType)) {
            currentSuperTypes.add(superType);
        }
    }

    default public void removeAllSuperTypes() {
        this.removeAllSuperTypes(null);
    }

    default public void removeAllSuperTypes(Game game) {
        List<SuperType> currentSuperTypes = game != null ? game.getState().getCreateMageObjectAttribute(this, game).getSuperType() : this.getSuperType();
        currentSuperTypes.clear();
    }

    default public void removeSuperType(SuperType superType) {
        this.removeSuperType(null, superType);
    }

    default public void removeSuperType(Game game, SuperType superType) {
        List<SuperType> currentSuperTypes = game != null ? game.getState().getCreateMageObjectAttribute(this, game).getSuperType() : this.getSuperType();
        currentSuperTypes.remove((Object)superType);
    }

    default public void addCardType(CardType ... cardTypes) {
        this.addCardType((Game)null, cardTypes);
    }

    default public void addCardType(Game game, CardType ... cardTypes) {
        List<CardType> currentCardTypes = game != null ? game.getState().getCreateMageObjectAttribute(this, game).getCardType() : this.getCardType();
        for (CardType cardType : cardTypes) {
            if (currentCardTypes.contains((Object)cardType)) continue;
            currentCardTypes.add(cardType);
        }
    }

    default public void removeCardType(CardType ... cardTypes) {
        this.removeCardType((Game)null, cardTypes);
    }

    default public void removeCardType(Game game, CardType ... cardTypes) {
        List<CardType> currentCardTypes = game != null ? game.getState().getCreateMageObjectAttribute(this, game).getCardType() : this.getCardType();
        for (CardType cardType : cardTypes) {
            currentCardTypes.remove((Object)cardType);
        }
    }

    default public void removeAllCardTypes() {
        this.removeAllCardTypes(null);
    }

    default public void removeAllCardTypes(Game game) {
        List<CardType> currentCardTypes = game != null ? game.getState().getCreateMageObjectAttribute(this, game).getCardType() : this.getCardType();
        currentCardTypes.clear();
    }

    default public void addSubType(Game game, Collection<SubType> subTypes) {
        for (SubType subType : subTypes) {
            this.addSubType(game, subType);
        }
    }

    default public void addSubType(SubType ... subTypes) {
        for (SubType subType : subTypes) {
            if (!subType.canGain(this) || this.getSubtype().contains((Object)subType)) continue;
            this.getSubtype().add(subType);
        }
    }

    default public void addSubType(Game game, SubType ... subTypes) {
        for (SubType subType : subTypes) {
            if (!subType.canGain(game, this) || this.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute(this, game).getSubtype().add(subType);
        }
    }

    default public void copySubTypesFrom(Game game, MageObject mageObject) {
        this.copySubTypesFrom(game, mageObject, null);
    }

    default public void copySubTypesFrom(Game game, MageObject mageObject, SubTypeSet subTypeSet) {
        if (subTypeSet == SubTypeSet.CreatureType || subTypeSet == null) {
            this.setIsAllCreatureTypes(game, mageObject.isAllCreatureTypes(game));
        }
        if (subTypeSet == SubTypeSet.NonBasicLandType || subTypeSet == null) {
            this.setIsAllNonbasicLandTypes(game, mageObject.isAllNonbasicLandTypes(game));
        }
        for (SubType subType : mageObject.getSubtype(game)) {
            if (subType.getSubTypeSet() != subTypeSet && subTypeSet != null) continue;
            this.addSubType(game, subType);
        }
    }

    default public void removeAllSubTypes(Game game) {
        this.removeAllSubTypes(game, null);
    }

    default public void removeAllSubTypes(Game game, SubTypeSet subTypeSet) {
        if (subTypeSet == null) {
            this.setIsAllCreatureTypes(game, false);
            this.setIsAllNonbasicLandTypes(game, false);
            game.getState().getCreateMageObjectAttribute(this, game).getSubtype().clear();
        } else if (subTypeSet == SubTypeSet.CreatureType) {
            this.removeAllCreatureTypes(game);
        } else if (subTypeSet == SubTypeSet.NonBasicLandType) {
            this.setIsAllNonbasicLandTypes(game, false);
            game.getState().getCreateMageObjectAttribute(this, game).getSubtype().removeAll(SubType.getLandTypes());
        } else {
            game.getState().getCreateMageObjectAttribute(this, game).getSubtype().removeAll(SubType.getBySubTypeSet(subTypeSet));
        }
    }

    default public void retainAllArtifactSubTypes(Game game) {
        this.setIsAllCreatureTypes(game, false);
        this.setIsAllNonbasicLandTypes(game, false);
        game.getState().getCreateMageObjectAttribute(this, game).getSubtype().retainAll(SubType.getArtifactTypes());
    }

    default public void retainAllEnchantmentSubTypes(Game game) {
        this.setIsAllCreatureTypes(game, false);
        this.setIsAllNonbasicLandTypes(game, false);
        game.getState().getCreateMageObjectAttribute(this, game).getSubtype().retainAll(SubType.getEnchantmentTypes());
    }

    default public void retainAllLandSubTypes(Game game) {
        this.setIsAllCreatureTypes(game, false);
        game.getState().getCreateMageObjectAttribute(this, game).getSubtype().retainAll(SubType.getLandTypes());
    }

    default public void removeAllCreatureTypes() {
        this.setIsAllCreatureTypes(false);
        this.getSubtype().removeAll(SubType.getCreatureTypes());
    }

    default public void removeAllCreatureTypes(Game game) {
        this.setIsAllCreatureTypes(game, false);
        game.getState().getCreateMageObjectAttribute(this, game).getSubtype().removeAll(SubType.getCreatureTypes());
    }

    default public void removeSubType(Game game, SubType subType) {
        game.getState().getCreateMageObjectAttribute(this, game).getSubtype().remove((Object)subType);
    }

    default public boolean shareTypes(Card otherCard, Game game) {
        return this.shareTypes(otherCard, game, false);
    }

    default public boolean shareTypes(Card otherCard, Game game, boolean permanentOnly) {
        if (otherCard == null) {
            throw new IllegalArgumentException("Params can't be null");
        }
        for (CardType type : this.getCardType(game)) {
            if (!otherCard.getCardType(game).contains((Object)type) || permanentOnly && !type.isPermanentType()) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    default public boolean shareCreatureTypes(Game game, MageObject otherCard) {
        if (!this.isCreature(game) && !this.isKindred(game)) {
            return false;
        }
        if (!otherCard.isCreature(game) && !otherCard.isKindred(game)) {
            return false;
        }
        isAllA = this.isAllCreatureTypes(game);
        if (isAllA) ** GOTO lbl-1000
        if (this.getSubtype(game).stream().map((Function<SubType, SubTypeSet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSubTypeSet(), (Lmage/constants/SubType;)Lmage/constants/SubTypeSet;)()).anyMatch((Predicate<SubTypeSet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lmage/constants/SubTypeSet;)Z)((SubTypeSet)SubTypeSet.CreatureType))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        isAnyA = v0;
        isAllB = otherCard.isAllCreatureTypes(game);
        if (isAllB) ** GOTO lbl-1000
        if (otherCard.getSubtype(game).stream().map((Function<SubType, SubTypeSet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSubTypeSet(), (Lmage/constants/SubType;)Lmage/constants/SubTypeSet;)()).anyMatch((Predicate<SubTypeSet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lmage/constants/SubTypeSet;)Z)((SubTypeSet)SubTypeSet.CreatureType))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = isAnyB = false;
        }
        if (!isAnyA || !isAnyB) {
            return false;
        }
        if (isAllA) {
            return isAllB != false || isAnyB != false;
        }
        return isAnyA != false && (isAllB != false || this.getSubtype(game).stream().filter((Predicate<SubType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$shareCreatureTypes$0(mage.constants.SubType ), (Lmage/constants/SubType;)Z)()).anyMatch((Predicate<SubType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$shareCreatureTypes$1(mage.MageObject mage.game.Game mage.constants.SubType ), (Lmage/constants/SubType;)Z)((MageObject)otherCard, (Game)game)) != false);
    }

    public boolean isAllCreatureTypes(Game var1);

    public void setIsAllCreatureTypes(boolean var1);

    public void setIsAllCreatureTypes(Game var1, boolean var2);

    public boolean isAllNonbasicLandTypes(Game var1);

    public void setIsAllNonbasicLandTypes(boolean var1);

    public void setIsAllNonbasicLandTypes(Game var1, boolean var2);

    public void removePTCDA();

    private static /* synthetic */ boolean lambda$shareCreatureTypes$1(MageObject otherCard, Game game, SubType subType) {
        return otherCard.hasSubtype(subType, game);
    }

    private static /* synthetic */ boolean lambda$shareCreatureTypes$0(SubType subType) {
        return subType.getSubTypeSet() == SubTypeSet.CreatureType;
    }
}

