/*
 * Decompiled with CFR 0.152.
 */
package mage;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.cards.FrameStyle;
import mage.cards.mock.MockCard;
import mage.constants.CardType;
import mage.constants.ManaType;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.MageObjectAttribute;
import mage.game.events.ZoneChangeEvent;
import mage.util.GameLog;
import mage.util.SubTypes;
import org.apache.log4j.Logger;

public abstract class MageObjectImpl
implements MageObject {
    private static final Logger logger = Logger.getLogger(MageObjectImpl.class);
    protected UUID objectId;
    protected String name;
    protected ManaCosts<ManaCost> manaCost;
    protected ObjectColor color;
    protected ObjectColor frameColor;
    protected FrameStyle frameStyle;
    private String expansionSetCode = "";
    private String cardNumber = "";
    private boolean usesVariousArt = false;
    private String imageFileName = "";
    private int imageNumber = 0;
    protected List<SuperType> supertype = new ArrayList<SuperType>();
    protected List<CardType> cardType = new ArrayList<CardType>();
    protected SubTypes subtype = new SubTypes(new SubType[0]);
    protected Abilities<Ability> abilities;
    protected String text;
    protected MageInt power;
    protected MageInt toughness;
    protected int startingLoyalty = -1;
    protected int startingDefense = -1;
    protected boolean copy;
    protected MageObject copyFrom;

    public MageObjectImpl() {
        this(UUID.randomUUID());
    }

    public MageObjectImpl(UUID id) {
        this.objectId = id;
        this.power = new MageInt(0);
        this.toughness = new MageInt(0);
        this.color = new ObjectColor();
        this.frameColor = new ObjectColor();
        this.frameStyle = FrameStyle.M15_NORMAL;
        this.manaCost = new ManaCostsImpl<ManaCost>();
        this.abilities = new AbilitiesImpl<Ability>();
    }

    protected MageObjectImpl(MageObjectImpl object) {
        this.objectId = object.objectId;
        this.name = object.name;
        this.manaCost = object.manaCost.copy();
        this.text = object.text;
        this.color = object.color.copy();
        this.frameColor = object.frameColor.copy();
        this.frameStyle = object.frameStyle;
        this.expansionSetCode = object.expansionSetCode;
        this.usesVariousArt = object.usesVariousArt;
        this.cardNumber = object.cardNumber;
        this.imageFileName = object.imageFileName;
        this.imageNumber = object.imageNumber;
        this.power = object.power.copy();
        this.toughness = object.toughness.copy();
        this.startingLoyalty = object.startingLoyalty;
        this.startingDefense = object.startingDefense;
        this.abilities = object.abilities.copy();
        this.cardType.addAll(object.cardType);
        this.subtype.copyFrom(object.subtype);
        this.supertype.addAll(object.supertype);
        this.copy = object.copy;
        this.copyFrom = object.copyFrom != null ? object.copyFrom.copy() : null;
    }

    @Override
    public UUID getId() {
        return this.objectId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdName() {
        return this.getName() + " [" + this.getId().toString().substring(0, 3) + ']';
    }

    @Override
    public String getLogName() {
        return GameLog.getColoredObjectIdName(this);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<CardType> getCardType(Game game) {
        MageObjectAttribute mageObjectAttribute;
        if (game != null && (mageObjectAttribute = game.getState().getMageObjectAttribute(this.getId())) != null) {
            return mageObjectAttribute.getCardType();
        }
        return this.cardType;
    }

    @Override
    public SubTypes getSubtype() {
        return this.subtype;
    }

    @Override
    public SubTypes getSubtype(Game game) {
        MageObjectAttribute mageObjectAttribute;
        if (game != null && (mageObjectAttribute = game.getState().getMageObjectAttribute(this.getId())) != null) {
            return mageObjectAttribute.getSubtype();
        }
        return this.subtype;
    }

    @Override
    public List<SuperType> getSuperType(Game game) {
        MageObjectAttribute mageObjectAttribute;
        if (game != null && (mageObjectAttribute = game.getState().getMageObjectAttribute(this.getId())) != null) {
            return mageObjectAttribute.getSuperType();
        }
        return this.supertype;
    }

    @Override
    public Abilities<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean hasAbility(Ability ability, Game game) {
        if (this.getAbilities().contains(ability)) {
            return true;
        }
        Abilities<Ability> otherAbilities = game.getState().getAllOtherAbilities(this.getId());
        return otherAbilities != null && otherAbilities.contains(ability);
    }

    @Override
    public MageInt getPower() {
        return this.power;
    }

    @Override
    public MageInt getToughness() {
        return this.toughness;
    }

    @Override
    public int getStartingLoyalty() {
        return this.startingLoyalty;
    }

    @Override
    public void setStartingLoyalty(int startingLoyalty) {
        this.startingLoyalty = startingLoyalty;
    }

    @Override
    public int getStartingDefense() {
        return this.startingDefense;
    }

    @Override
    public void setStartingDefense(int startingDefense) {
        this.startingDefense = startingDefense;
    }

    @Override
    public ObjectColor getColor() {
        return this.color;
    }

    @Override
    public ObjectColor getColor(Game game) {
        MageObjectAttribute mageObjectAttribute;
        if (game != null && (mageObjectAttribute = game.getState().getMageObjectAttribute(this.getId())) != null) {
            return mageObjectAttribute.getColor();
        }
        return this.color;
    }

    @Override
    public ObjectColor getFrameColor(Game game) {
        if (this.isLand(game) && !(this instanceof MockCard)) {
            ObjectColor cl = this.frameColor.copy();
            EnumSet<ManaType> manaTypes = EnumSet.noneOf(ManaType.class);
            for (Ability ab : this.getAbilities()) {
                if (!(ab instanceof ActivatedManaAbilityImpl)) continue;
                manaTypes.addAll(((ActivatedManaAbilityImpl)ab).getProducableManaTypes(game));
            }
            cl.setWhite(manaTypes.contains((Object)ManaType.WHITE));
            cl.setBlue(manaTypes.contains((Object)ManaType.BLUE));
            cl.setBlack(manaTypes.contains((Object)ManaType.BLACK));
            cl.setRed(manaTypes.contains((Object)ManaType.RED));
            cl.setGreen(manaTypes.contains((Object)ManaType.GREEN));
            return cl;
        }
        return this.frameColor;
    }

    @Override
    public FrameStyle getFrameStyle() {
        return this.frameStyle;
    }

    @Override
    public String getExpansionSetCode() {
        return this.expansionSetCode;
    }

    @Override
    public void setExpansionSetCode(String expansionSetCode) {
        this.expansionSetCode = expansionSetCode;
    }

    @Override
    public boolean getUsesVariousArt() {
        return this.usesVariousArt;
    }

    @Override
    public void setUsesVariousArt(boolean usesVariousArt) {
        this.usesVariousArt = usesVariousArt;
    }

    @Override
    public String getCardNumber() {
        return this.cardNumber;
    }

    @Override
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    @Override
    public String getImageFileName() {
        return this.imageFileName;
    }

    @Override
    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    @Override
    public Integer getImageNumber() {
        return this.imageNumber;
    }

    @Override
    public void setImageNumber(Integer imageNumber) {
        this.imageNumber = imageNumber;
    }

    @Override
    public ManaCosts<ManaCost> getManaCost() {
        return this.manaCost;
    }

    @Override
    public void setManaCost(ManaCosts<ManaCost> costs) {
        this.manaCost = costs.copy();
    }

    @Override
    public int getManaValue() {
        if (this.manaCost != null) {
            return this.manaCost.manaValue();
        }
        return 0;
    }

    @Override
    public boolean hasSubtype(SubType value, Game game) {
        if (value == null) {
            return false;
        }
        return value.getSubTypeSet() == SubTypeSet.CreatureType && this.isAllCreatureTypes(game) || value.getSubTypeSet() == SubTypeSet.NonBasicLandType && this.isAllNonbasicLandTypes(game) || this.getSubtype(game).contains((Object)value);
    }

    @Override
    public void setCopy(boolean isCopy, MageObject copyFrom) {
        this.copy = isCopy;
        this.copyFrom = copyFrom != null ? copyFrom.copy() : null;
    }

    @Override
    public MageObject getCopyFrom() {
        return this.copyFrom;
    }

    @Override
    public boolean isCopy() {
        return this.copy;
    }

    @Override
    public int getZoneChangeCounter(Game game) {
        return game.getState().getZoneChangeCounter(this.objectId);
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        game.getState().updateZoneChangeCounter(this.objectId);
    }

    @Override
    public void setZoneChangeCounter(int value, Game game) {
        game.getState().setZoneChangeCounter(this.objectId, value);
    }

    @Override
    public boolean isAllCreatureTypes(Game game) {
        return this.getSubtype(game).isAllCreatureTypes();
    }

    @Override
    public void setIsAllCreatureTypes(boolean value) {
        this.getSubtype().setIsAllCreatureTypes(value && (this.isKindred() || this.isCreature()));
    }

    @Override
    public void setIsAllCreatureTypes(Game game, boolean value) {
        this.getSubtype(game).setIsAllCreatureTypes(value && (this.isKindred(game) || this.isCreature(game)));
    }

    @Override
    public boolean isAllNonbasicLandTypes(Game game) {
        return this.getSubtype(game).isAllNonbasicLandTypes();
    }

    @Override
    public void setIsAllNonbasicLandTypes(boolean value) {
        this.getSubtype().setIsAllNonbasicLandTypes(value && this.isLand());
    }

    @Override
    public void setIsAllNonbasicLandTypes(Game game, boolean value) {
        this.getSubtype(game).setIsAllNonbasicLandTypes(value && this.isLand(game));
    }

    @Override
    public void removePTCDA() {
        Iterator iter = this.getAbilities().iterator();
        block0: while (iter.hasNext()) {
            Ability ability = (Ability)iter.next();
            for (Effect effect : ability.getEffects()) {
                if (!(effect instanceof ContinuousEffect) || ((ContinuousEffect)effect).getSublayer() != SubLayer.CharacteristicDefining_7a) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    public String toString() {
        return this.getIdName() + " (" + super.getClass().getSuperclass().getSimpleName() + " -> " + this.getClass().getSimpleName() + ")";
    }
}

