/*
 * Decompiled with CFR 0.152.
 */
package mage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mage.constants.ColoredManaSymbol;
import mage.util.Copyable;

public class ObjectColor
implements Serializable,
Copyable<ObjectColor>,
Comparable<ObjectColor> {
    public static final ObjectColor WHITE = new ObjectColor("W");
    public static final ObjectColor BLUE = new ObjectColor("U");
    public static final ObjectColor BLACK = new ObjectColor("B");
    public static final ObjectColor RED = new ObjectColor("R");
    public static final ObjectColor GREEN = new ObjectColor("G");
    public static final ObjectColor COLORLESS = new ObjectColor();
    private static final List<ObjectColor> allColors = Arrays.asList(WHITE, BLUE, BLACK, RED, GREEN);
    private boolean white;
    private boolean blue;
    private boolean black;
    private boolean red;
    private boolean green;

    public ObjectColor() {
    }

    public ObjectColor(String color) {
        block7: for (int i = 0; i < color.length(); ++i) {
            switch (color.charAt(i)) {
                case 'W': {
                    this.white = true;
                    continue block7;
                }
                case 'U': {
                    this.blue = true;
                    continue block7;
                }
                case 'B': {
                    this.black = true;
                    continue block7;
                }
                case 'R': {
                    this.red = true;
                    continue block7;
                }
                case 'G': {
                    this.green = true;
                }
            }
        }
    }

    public ObjectColor(ObjectColor color) {
        this.white = color.white;
        this.blue = color.blue;
        this.black = color.black;
        this.red = color.red;
        this.green = color.green;
    }

    public ObjectColor union(ObjectColor other) {
        ObjectColor newColor = new ObjectColor();
        newColor.white = this.white || other.white;
        newColor.blue = this.blue || other.blue;
        newColor.black = this.black || other.black;
        newColor.red = this.red || other.red;
        newColor.green = this.green || other.green;
        return newColor;
    }

    public ObjectColor intersection(ObjectColor other) {
        ObjectColor newColor = new ObjectColor();
        newColor.white = this.white && other.white;
        newColor.blue = this.blue && other.blue;
        newColor.black = this.black && other.black;
        newColor.red = this.red && other.red;
        newColor.green = this.green && other.green;
        return newColor;
    }

    public int getColorCount() {
        int count = 0;
        if (this.white) {
            ++count;
        }
        if (this.blue) {
            ++count;
        }
        if (this.black) {
            ++count;
        }
        if (this.green) {
            ++count;
        }
        if (this.red) {
            ++count;
        }
        return count;
    }

    public List<ObjectColor> getColors() {
        ArrayList<ObjectColor> colors = new ArrayList<ObjectColor>();
        int firstColor = 5000;
        int secondColor = -1;
        if (this.isWhite()) {
            firstColor = 1;
            secondColor = 1;
        }
        if (this.isBlue()) {
            firstColor = Math.min(firstColor, 2);
            secondColor = Math.max(secondColor, 2);
        }
        if (this.isBlack()) {
            firstColor = Math.min(firstColor, 3);
            secondColor = Math.max(secondColor, 3);
        }
        if (this.isRed()) {
            firstColor = Math.min(firstColor, 4);
            secondColor = Math.max(secondColor, 4);
        }
        if (this.isGreen()) {
            firstColor = Math.min(firstColor, 5);
            secondColor = Math.max(secondColor, 5);
        }
        if (this.isWhite()) {
            colors.add(WHITE);
        }
        if (this.isBlue()) {
            colors.add(BLUE);
        }
        if (this.isBlack()) {
            colors.add(BLACK);
        }
        if (this.isRed()) {
            colors.add(RED);
        }
        if (this.isGreen()) {
            colors.add(GREEN);
        }
        if (colors.size() >= 2 && secondColor - firstColor >= 3) {
            Collections.swap(colors, 0, 1);
        }
        return colors;
    }

    public void setColor(ObjectColor color) {
        this.setBlack(color != null && color.isBlack());
        this.setBlue(color != null && color.isBlue());
        this.setGreen(color != null && color.isGreen());
        this.setRed(color != null && color.isRed());
        this.setWhite(color != null && color.isWhite());
    }

    public void addColor(ObjectColor color) {
        if (color.isWhite()) {
            this.setWhite(true);
        }
        if (color.isBlue()) {
            this.setBlue(true);
        }
        if (color.isBlack()) {
            this.setBlack(true);
        }
        if (color.isRed()) {
            this.setRed(true);
        }
        if (color.isGreen()) {
            this.setGreen(true);
        }
    }

    public boolean isColorless() {
        return !this.hasColor();
    }

    public boolean hasColor() {
        return this.white || this.blue || this.black || this.red || this.green;
    }

    public boolean isMulticolored() {
        if (this.isColorless()) {
            return false;
        }
        if (this.white) {
            return this.blue || this.black || this.red || this.green;
        }
        if (this.blue) {
            return this.black || this.red || this.green;
        }
        if (this.black) {
            return this.red || this.green;
        }
        if (this.red) {
            return this.green;
        }
        return false;
    }

    public boolean isWhite() {
        return this.white;
    }

    public void setWhite(boolean white) {
        this.white = white;
    }

    public boolean isBlue() {
        return this.blue;
    }

    public void setBlue(boolean blue) {
        this.blue = blue;
    }

    public boolean isBlack() {
        return this.black;
    }

    public void setBlack(boolean black) {
        this.black = black;
    }

    public boolean isRed() {
        return this.red;
    }

    public void setRed(boolean red) {
        this.red = red;
    }

    public boolean isGreen() {
        return this.green;
    }

    public void setGreen(boolean green) {
        this.green = green;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(5);
        if (this.white) {
            sb.append('W');
        }
        if (this.blue) {
            sb.append('U');
        }
        if (this.black) {
            sb.append('B');
        }
        if (this.red) {
            sb.append('R');
        }
        if (this.green) {
            sb.append('G');
        }
        return sb.toString();
    }

    public String getDescription() {
        if (this.isMulticolored()) {
            return "multicolored";
        }
        if (this.white) {
            return "white";
        }
        if (this.blue) {
            return "blue";
        }
        if (this.black) {
            return "black";
        }
        if (this.red) {
            return "red";
        }
        if (this.green) {
            return "green";
        }
        return "colorless";
    }

    public boolean equals(Object color) {
        if (this == color) {
            return true;
        }
        if (!(color instanceof ObjectColor)) {
            return false;
        }
        ObjectColor test = (ObjectColor)color;
        if (test.white != this.white) {
            return false;
        }
        if (test.blue != this.blue) {
            return false;
        }
        if (test.black != this.black) {
            return false;
        }
        if (test.red != this.red) {
            return false;
        }
        return test.green == this.green;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (this.white ? 1 : 0);
        hash = 23 * hash + (this.blue ? 1 : 0);
        hash = 23 * hash + (this.black ? 1 : 0);
        hash = 23 * hash + (this.red ? 1 : 0);
        hash = 23 * hash + (this.green ? 1 : 0);
        return hash;
    }

    public boolean contains(ObjectColor color) {
        if (Objects.equals(this, color)) {
            return true;
        }
        if (color.white && this.white) {
            return true;
        }
        if (color.blue && this.blue) {
            return true;
        }
        if (color.black && this.black) {
            return true;
        }
        if (color.red && this.red) {
            return true;
        }
        return color.green && this.green;
    }

    public boolean shares(ObjectColor color) {
        return !color.isColorless() && (color.white && this.white || color.blue && this.blue || color.black && this.black || color.red && this.red || color.green && this.green);
    }

    @Override
    public ObjectColor copy() {
        return new ObjectColor(this);
    }

    @Override
    public int compareTo(ObjectColor o) {
        int o1 = 0;
        int o2 = 0;
        if (this.isMulticolored()) {
            o1 = 7;
        } else if (this.isColorless()) {
            o1 = 0;
        } else if (this.isBlack()) {
            o1 = 1;
        } else if (this.isBlue()) {
            o1 = 2;
        } else if (this.isGreen()) {
            o1 = 3;
        } else if (this.isRed()) {
            o1 = 4;
        } else if (this.isWhite()) {
            o1 = 5;
        }
        if (o.isMulticolored()) {
            o2 = 7;
        } else if (o.isColorless()) {
            o2 = 0;
        } else if (o.isBlack()) {
            o2 = 1;
        } else if (o.isBlue()) {
            o2 = 2;
        } else if (o.isGreen()) {
            o2 = 3;
        } else if (o.isRed()) {
            o2 = 4;
        } else if (o.isWhite()) {
            o2 = 5;
        }
        return o1 - o2;
    }

    public ColoredManaSymbol getOneColoredManaSymbol() {
        if (this.isMulticolored()) {
            throw new IllegalStateException("Found multicolor object, but was waiting for simple color.");
        }
        if (this.isBlack()) {
            return ColoredManaSymbol.B;
        }
        if (this.isRed()) {
            return ColoredManaSymbol.R;
        }
        if (this.isBlue()) {
            return ColoredManaSymbol.U;
        }
        if (this.isGreen()) {
            return ColoredManaSymbol.G;
        }
        if (this.isWhite()) {
            return ColoredManaSymbol.W;
        }
        return null;
    }

    public static List<ObjectColor> getAllColors() {
        return allColors;
    }
}

