/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.UUID;
import mage.game.Game;

public class ActivationInfo {
    protected int turnNum = 0;
    protected int activationCounter = 0;
    protected String key;

    public static ActivationInfo getInstance(Game game, UUID sourceId) {
        return ActivationInfo.getInstance(game, sourceId, game.getState().getZoneChangeCounter(sourceId));
    }

    public static ActivationInfo getInstance(Game game, UUID sourceId, int zoneChangeCounter) {
        ActivationInfo activationInfo;
        String key = "ActivationInfo" + sourceId.toString() + zoneChangeCounter;
        Integer activations = (Integer)game.getState().getValue(key);
        if (activations != null) {
            Integer turnNum = (Integer)game.getState().getValue(key + 'T');
            activationInfo = new ActivationInfo(game, turnNum, activations);
        } else {
            activationInfo = new ActivationInfo(game, game.getTurnNum(), 0);
        }
        activationInfo.setKey(key);
        return activationInfo;
    }

    public void setKey(String key) {
        this.key = key;
    }

    protected ActivationInfo(Game game, int turnNum, int activationCounter) {
        this.turnNum = turnNum;
        this.activationCounter = activationCounter;
    }

    public void addActivation(Game game) {
        if (game.getTurnNum() != this.turnNum) {
            this.activationCounter = 1;
            this.turnNum = game.getTurnNum();
        } else {
            ++this.activationCounter;
        }
        game.getState().setValue(this.key, this.activationCounter);
        game.getState().setValue(this.key + 'T', this.turnNum);
    }

    public int getActivationCounter() {
        return this.activationCounter;
    }
}

