/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.costs.OptionalAdditionalModeSourceCosts;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.Filter;
import mage.filter.FilterPlayer;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;
import mage.util.Copyable;
import mage.util.RandomUtil;

public class Modes
extends LinkedHashMap<UUID, Mode>
implements Copyable<Modes> {
    public static final UUID CHOOSE_OPTION_DONE_ID = UUID.fromString("33e72ad6-17ae-4bfb-a097-6e7aa06b49e9");
    public static final UUID CHOOSE_OPTION_CANCEL_ID = UUID.fromString("0125bd0c-5610-4eba-bc80-fc6d0a7b9de6");
    private Mode currentMode;
    private final List<UUID> selectedModes = new ArrayList<UUID>();
    private final Map<UUID, Mode> selectedDuplicateModes = new LinkedHashMap<UUID, Mode>();
    private final Map<UUID, UUID> selectedDuplicateToOriginalModeRefs = new LinkedHashMap<UUID, UUID>();
    private int minModes;
    private int maxModes;
    private int maxPawPrints;
    private Filter maxModesFilter;
    private Condition moreCondition;
    private int moreLimit;
    private boolean limitUsageByOnce = false;
    private boolean limitUsageResetOnNewTurn = false;
    private String chooseText = null;
    private TargetController chooseController;
    private boolean mayChooseSameModeMoreThanOnce = false;
    private boolean mayChooseNone = false;
    private boolean isRandom = false;

    public Modes() {
        this.currentMode = new Mode((Effect)null);
        this.put(this.currentMode.getId(), this.currentMode);
        this.minModes = 1;
        this.maxModes = 1;
        this.maxPawPrints = 0;
        this.addSelectedMode(this.currentMode.getId());
        this.chooseController = TargetController.YOU;
    }

    protected Modes(Modes modes) {
        for (Map.Entry entry : modes.entrySet()) {
            this.put(entry.getKey(), ((Mode)entry.getValue()).copy());
        }
        for (Map.Entry<Object, Object> entry : modes.selectedDuplicateModes.entrySet()) {
            this.selectedDuplicateModes.put((UUID)entry.getKey(), ((Mode)entry.getValue()).copy());
        }
        this.selectedDuplicateToOriginalModeRefs.putAll(modes.selectedDuplicateToOriginalModeRefs);
        this.minModes = modes.minModes;
        this.maxModes = modes.maxModes;
        this.maxPawPrints = modes.maxPawPrints;
        this.maxModesFilter = modes.maxModesFilter;
        this.moreCondition = modes.moreCondition;
        this.moreLimit = modes.moreLimit;
        this.limitUsageByOnce = modes.limitUsageByOnce;
        this.limitUsageResetOnNewTurn = modes.limitUsageResetOnNewTurn;
        this.chooseText = modes.chooseText;
        this.chooseController = modes.chooseController;
        this.mayChooseSameModeMoreThanOnce = modes.mayChooseSameModeMoreThanOnce;
        this.mayChooseNone = modes.mayChooseNone;
        this.isRandom = modes.isRandom;
        this.selectedModes.addAll(modes.getSelectedModes());
        this.currentMode = modes.getSelectedModes().isEmpty() ? (Mode)this.values().iterator().next() : this.get(modes.getMode().getId());
    }

    @Override
    public Modes copy() {
        return new Modes(this);
    }

    @Override
    public Mode get(Object key) {
        Mode modeToGet = (Mode)super.get(key);
        if (modeToGet == null && this.mayChooseSameModeMoreThanOnce) {
            modeToGet = this.selectedDuplicateModes.get(key);
        }
        return modeToGet;
    }

    public Stream<Mode> streamAlreadySelectedModes(Ability source, Game game) {
        Set<UUID> selected = this.getAlreadySelectedModes(source, game, true);
        return super.values().stream().filter(m -> selected.contains(m.getId()));
    }

    public Mode getMode() {
        return this.currentMode;
    }

    public UUID getModeId(int index) {
        int idx = 0;
        if (this.mayChooseSameModeMoreThanOnce) {
            for (UUID modeId : this.getSelectedModes()) {
                if (++idx != index) continue;
                return modeId;
            }
        } else {
            for (Mode mode : this.values()) {
                if (++idx != index) continue;
                return mode.getId();
            }
        }
        return null;
    }

    public List<UUID> getSelectedModes() {
        ArrayList<UUID> res = new ArrayList<UUID>(this.size());
        for (Mode mode : this.values()) {
            for (UUID selectedId : this.selectedModes) {
                UUID selectedOriginalId = this.selectedDuplicateToOriginalModeRefs.get(selectedId);
                if (!Objects.equals(mode.getId(), selectedId) && !Objects.equals(mode.getId(), selectedOriginalId)) continue;
                res.add(selectedId);
            }
        }
        return res;
    }

    public void clearSelectedModes() {
        this.selectedModes.clear();
        this.selectedDuplicateModes.clear();
        this.selectedDuplicateToOriginalModeRefs.clear();
    }

    public int getSelectedStats(UUID modeId) {
        int count = 0;
        if (this.selectedModes.contains(modeId)) {
            ++count;
            UUID originalId = this.selectedDuplicateModes.containsKey(modeId) ? this.selectedDuplicateToOriginalModeRefs.get(modeId) : modeId;
            for (UUID id : this.selectedDuplicateToOriginalModeRefs.values()) {
                if (!id.equals(originalId)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getSelectedPawPrints() {
        return this.selectedModes.stream().mapToInt(modeID -> this.get(modeID).getPawPrintValue()).sum();
    }

    public void setMinModes(int minModes) {
        this.minModes = minModes;
    }

    public int getMinModes() {
        return this.minModes;
    }

    public void setMaxModes(int maxModes) {
        this.maxModes = maxModes;
    }

    public Filter getMaxModesFilter() {
        return this.maxModesFilter;
    }

    public void setMaxModesFilter(Filter maxModesFilter) {
        if (maxModesFilter != null && !(maxModesFilter instanceof FilterPlayer)) {
            throw new IllegalArgumentException("Wrong code usage: max modes filter support only FilterPlayer");
        }
        this.maxModesFilter = maxModesFilter;
    }

    public int getMaxModes(Game game, Ability source) {
        int realMaxModes = this.maxModes;
        if (game == null || source == null) {
            return realMaxModes;
        }
        if (this.moreCondition != null && this.moreCondition.apply(game, source)) {
            realMaxModes = Math.min(this.moreLimit, this.size());
        }
        if (this.getMaxModesFilter() != null && this.maxModesFilter instanceof FilterPlayer) {
            realMaxModes = 0;
            for (UUID targetPlayerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player targetPlayer = game.getPlayer(targetPlayerId);
                if (!((FilterPlayer)this.maxModesFilter).match(targetPlayer, source.getControllerId(), source, game)) continue;
                ++realMaxModes;
            }
            if (realMaxModes > this.maxModes) {
                realMaxModes = this.maxModes;
            }
        }
        return realMaxModes;
    }

    public void setMaxPawPrints(int maxPawPrints) {
        this.maxPawPrints = maxPawPrints;
    }

    public int getMaxPawPrints() {
        return this.maxPawPrints;
    }

    public void setChooseController(TargetController chooseController) {
        this.chooseController = chooseController;
    }

    public TargetController getChooseController() {
        return this.chooseController;
    }

    public void setActiveMode(Mode mode) {
        this.setActiveMode(mode.getId());
    }

    public void setActiveMode(UUID modeId) {
        if (this.selectedModes.contains(modeId)) {
            this.currentMode = this.get(modeId);
        }
    }

    public void addMode(Mode mode) {
        if (this.maxPawPrints > 0 && mode.getPawPrintValue() == 0) {
            throw new IllegalArgumentException("Mode must have nonzero pawprints value in a pawprints mode set.");
        }
        if (this.maxPawPrints == 0 && mode.getPawPrintValue() > 0) {
            throw new IllegalArgumentException("Cannot add pawprints mode to non-pawprints mode set.");
        }
        this.put(mode.getId(), mode);
    }

    public void setMoreCondition(int moreLimit, Condition moreCondition) {
        this.moreLimit = moreLimit;
        this.moreCondition = moreCondition;
    }

    private boolean isAlreadySelectedModesOutdated(Game game, Ability source) {
        return this.isLimitUsageResetOnNewTurn() && this.getOnceTurnNum(game, source) != game.getTurnNum();
    }

    private boolean isSelectedValid(Ability source, Game game) {
        if (this.isLimitUsageByOnce()) {
            this.setOnceSelectedModes(source, game);
        }
        return this.selectedModes.size() >= this.getMinModes() || this.selectedModes.size() == 0 && this.mayChooseNone;
    }

    public boolean choose(Game game, Ability source) {
        if (this.isAlreadySelectedModesOutdated(game, source)) {
            this.clearAlreadySelectedModes(source, game);
        }
        this.clearSelectedModes();
        if (this.isRandom && this.limitUsageByOnce) {
            throw new IllegalStateException("Wrong code usage: random modes are not support with once usage");
        }
        List<Mode> availableModes = this.getAvailableModes(source, game);
        if (availableModes.size() == 0) {
            return this.isSelectedValid(source, game);
        }
        if (this.size() > 1) {
            UUID playerId;
            Card card = game.getCard(source.getSourceId());
            if (card != null) {
                for (Ability ability : card.getAbilities(game)) {
                    if (!(ability instanceof OptionalAdditionalModeSourceCosts)) continue;
                    ((OptionalAdditionalModeSourceCosts)((Object)ability)).changeModes(source, game);
                }
            }
            if (this.isRandom) {
                this.addSelectedMode(availableModes.get(RandomUtil.nextInt(availableModes.size())).getId());
                return this.isSelectedValid(source, game);
            }
            if (this.size() == this.getMinModes() && !this.isMayChooseSameModeMoreThanOnce()) {
                Set<UUID> onceSelectedModes = null;
                if (this.isLimitUsageByOnce()) {
                    onceSelectedModes = this.getAlreadySelectedModes(source, game, true);
                }
                for (Mode mode : this.values()) {
                    if (this.isLimitUsageByOnce() && onceSelectedModes != null && onceSelectedModes.contains(mode.getId()) || !mode.getTargets().canChoose(source.getControllerId(), source, game)) continue;
                    this.addSelectedMode(mode.getId());
                }
                return this.isSelectedValid(source, game);
            }
            if (this.chooseController == TargetController.OPPONENT) {
                TargetOpponent targetOpponent = new TargetOpponent();
                targetOpponent.choose(Outcome.Benefit, source.getControllerId(), source.getSourceId(), source, game);
                playerId = targetOpponent.getFirstTarget();
            } else {
                playerId = source.getControllerId();
            }
            Player player = game.getPlayer(playerId);
            if (player == null) {
                return false;
            }
            this.currentMode = null;
            int currentMaxModes = this.getMaxModes(game, source);
            while (this.selectedModes.size() < currentMaxModes && this.maxPawPrints == 0 || this.getSelectedPawPrints() < this.maxPawPrints && this.maxPawPrints > 0) {
                Mode choice = player.chooseMode(this, source, game);
                if (choice == null) {
                    return this.isSelectedValid(source, game);
                }
                this.addSelectedMode(choice.getId());
                if (this.currentMode != null) continue;
                this.currentMode = choice;
            }
            if (this.chooseController == TargetController.OPPONENT) {
                this.selectedModes.stream().map(this::get).map(Mode::getEffects).forEach((? super T effects) -> effects.setValue("choosingPlayer", playerId));
            }
        } else {
            Mode mode = (Mode)this.values().iterator().next();
            this.addSelectedMode(mode.getId());
            this.setActiveMode(mode);
        }
        return this.isSelectedValid(source, game);
    }

    private void setOnceSelectedModes(Ability source, Game game) {
        for (UUID modeId : this.getSelectedModes()) {
            String key = this.getSelectedModesKey(source, game, modeId);
            game.getState().setValue(key, true);
        }
    }

    private void clearAlreadySelectedModes(Ability source, Game game) {
        for (UUID modeId : this.getAlreadySelectedModes(source, game, false)) {
            String key = this.getSelectedModesKey(source, game, modeId);
            game.getState().setValue(key, false);
        }
        this.setOnceTurnNum(game, source);
    }

    public void addSelectedMode(UUID modeId) {
        if (!this.containsKey(modeId)) {
            throw new IllegalArgumentException("Unknown modeId to select");
        }
        Mode mode = this.get(modeId);
        if (this.selectedModes.contains(modeId) && this.mayChooseSameModeMoreThanOnce) {
            Mode duplicateMode = mode.copy();
            UUID originalId = modeId;
            duplicateMode.setRandomId();
            modeId = duplicateMode.getId();
            this.selectedDuplicateModes.put(modeId, duplicateMode);
            this.selectedDuplicateToOriginalModeRefs.put(duplicateMode.getId(), originalId);
        }
        this.selectedModes.add(modeId);
    }

    public void removeSelectedMode(UUID modeId) {
        this.selectedModes.remove(modeId);
        this.selectedDuplicateModes.remove(modeId);
        this.selectedDuplicateToOriginalModeRefs.remove(modeId);
    }

    private Set<UUID> getAlreadySelectedModes(Ability source, Game game, boolean ignoreOutdatedData) {
        HashSet<UUID> res = new HashSet<UUID>();
        if (ignoreOutdatedData && this.isAlreadySelectedModesOutdated(game, source)) {
            return res;
        }
        for (UUID modeId : this.keySet()) {
            Object exist = game.getState().getValue(this.getSelectedModesKey(source, game, modeId));
            if (exist != Boolean.TRUE) continue;
            res.add(modeId);
        }
        return res;
    }

    private String getKeyPrefix(Game game, Ability source) {
        return source == null || source.getSourceId() == null ? "" : source.getSourceId().toString() + game.getState().getZoneChangeCounter(source.getSourceId());
    }

    private String getSelectedModesKey(Ability source, Game game, UUID modeId) {
        return this.getKeyPrefix(game, source) + modeId.toString();
    }

    private String getOnceTurnNumKey(Ability source, Game game) {
        return this.getKeyPrefix(game, source) + "turnNum";
    }

    private int getOnceTurnNum(Game game, Ability source) {
        Object object = game.getState().getValue(this.getOnceTurnNumKey(source, game));
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    private void setOnceTurnNum(Game game, Ability source) {
        game.getState().setValue(this.getOnceTurnNumKey(source, game), game.getTurnNum());
    }

    public List<Mode> getAvailableModes(Ability source, Game game) {
        ArrayList<Mode> availableModes = new ArrayList<Mode>();
        Set<Object> nonAvailableModes = this.isMayChooseSameModeMoreThanOnce() ? new HashSet() : this.getAlreadySelectedModes(source, game, true);
        for (Mode mode : this.values()) {
            if (this.isLimitUsageByOnce() && nonAvailableModes.contains(mode.getId()) || this.getMaxPawPrints() > 0 && this.getSelectedPawPrints() + mode.getPawPrintValue() > this.getMaxPawPrints()) continue;
            availableModes.add(mode);
        }
        return availableModes;
    }

    public String getText() {
        if (this.size() <= 1) {
            return this.getMode().getEffects().getText(this.getMode());
        }
        StringBuilder sb = new StringBuilder();
        if (this.chooseText == null) {
            if (this.chooseController == TargetController.OPPONENT) {
                sb.append("an opponent chooses ");
            } else {
                if (this.mayChooseNone) {
                    sb.append("you may ");
                }
                sb.append("choose ");
            }
            if (this.getMaxPawPrints() > 0) {
                sb.append("up to ").append(CardUtil.numberToText(this.getMaxPawPrints())).append(" {P} worth of modes");
            } else if (this.getMinModes() == 0 && this.getMaxModes(null, null) == 1) {
                sb.append("up to one");
            } else if (this.getMinModes() == 0 && this.getMaxModes(null, null) > 2) {
                sb.append("any number");
            } else if (this.getMinModes() == 1 && this.getMaxModes(null, null) == 2) {
                sb.append("one or both");
            } else if (this.getMinModes() == 1 && this.getMaxModes(null, null) > 2) {
                sb.append("one or more");
            } else if (this.getMinModes() == this.getMaxModes(null, null)) {
                sb.append(CardUtil.numberToText(this.getMinModes()));
            } else {
                throw new UnsupportedOperationException(String.format("no text available for this selection of min and max modes (%d and %d)", this.getMinModes(), this.getMaxModes(null, null)));
            }
            if (this.isRandom) {
                sb.append(" at random");
            }
            if (this.isLimitUsageByOnce() && this.getMaxModesFilter() == null) {
                sb.append(" that hasn't been chosen");
            }
            if (this.isLimitUsageResetOnNewTurn()) {
                sb.append(" this turn");
            }
        } else {
            sb.append(this.chooseText);
        }
        if (this.getMaxModesFilter() != null) {
            sb.append(". Each mode must target ").append(this.getMaxModesFilter().getMessage()).append('.');
        } else if (this.isMayChooseSameModeMoreThanOnce()) {
            sb.append(". You may choose the same mode more than once.");
        } else if (this.chooseText == null) {
            sb.append(" &mdash;");
        }
        sb.append("<br>");
        for (Mode mode : this.values()) {
            if (mode.getCost() != null && mode.getFlavorWord() == null) {
                sb.append("+ ");
            } else if (mode.getPawPrintValue() > 0) {
                for (int i = 0; i < mode.getPawPrintValue(); ++i) {
                    sb.append("{P}");
                }
                sb.append(" &mdash; ");
            } else {
                sb.append("&bull ");
            }
            sb.append(mode.getEffects().getTextStartingUpperCase(mode));
            sb.append("<br>");
        }
        return sb.toString();
    }

    public String getText(String sourceName) {
        return this.getText().replace("{this}", sourceName);
    }

    public boolean isLimitUsageByOnce() {
        return this.limitUsageByOnce;
    }

    public void setLimitUsageByOnce(boolean resetOnNewTurn) {
        this.limitUsageByOnce = true;
        this.limitUsageResetOnNewTurn = resetOnNewTurn;
    }

    public boolean isMayChooseSameModeMoreThanOnce() {
        return this.mayChooseSameModeMoreThanOnce;
    }

    public void setMayChooseSameModeMoreThanOnce(boolean mayChooseSameModeMoreThanOnce) {
        this.mayChooseSameModeMoreThanOnce = mayChooseSameModeMoreThanOnce;
    }

    public void setRandom(boolean isRandom) {
        this.isRandom = isRandom;
    }

    public boolean isLimitUsageResetOnNewTurn() {
        return this.limitUsageResetOnNewTurn;
    }

    public void setChooseText(String chooseText) {
        this.chooseText = chooseText;
    }

    public void setMayChooseNone(boolean mayChooseNone) {
        this.mayChooseNone = mayChooseNone;
    }

    public boolean isMayChooseNone() {
        return this.mayChooseNone;
    }
}

