/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.mana.AlternateManaPaymentAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.mana.ManaOptions;
import mage.constants.AbilityType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

public abstract class SpecialAction
extends ActivatedAbilityImpl {
    private final AlternateManaPaymentAbility manaAbility;

    public SpecialAction() {
        this(Zone.ALL);
    }

    public SpecialAction(Zone zone) {
        this(zone, null);
    }

    public SpecialAction(Zone zone, AlternateManaPaymentAbility manaAbility) {
        super(AbilityType.SPECIAL_ACTION, zone);
        this.usesStack = false;
        this.manaAbility = manaAbility;
    }

    protected SpecialAction(SpecialAction action) {
        super(action);
        this.manaAbility = action.manaAbility;
    }

    public boolean isManaAction() {
        return this.manaAbility != null;
    }

    public ManaOptions getManaOptions(Ability source, Game game, ManaCost unpaid) {
        if (this.manaAbility != null) {
            return this.manaAbility.getManaOptions(source, game, unpaid);
        }
        return null;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        if (this.isManaAction()) {
            int currentStepOrder = 0;
            StackObject stackObject = game.getStack().getFirstOrNull();
            if (stackObject instanceof Spell) {
                currentStepOrder = ((Spell)stackObject).getCurrentActivatingManaAbilitiesStep().getStepOrder();
            }
            if (currentStepOrder > this.manaAbility.useOnActivationManaAbilityStep().getStepOrder()) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
        }
        return super.canActivate(playerId, game);
    }
}

