/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;

public class AttacksAndIsNotBlockedTriggeredAbility
extends TriggeredAbilityImpl {
    private final SetTargetPointer setTargetPointer;

    public AttacksAndIsNotBlockedTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public AttacksAndIsNotBlockedTriggeredAbility(Effect effect, boolean optional) {
        this(effect, optional, SetTargetPointer.NONE);
    }

    public AttacksAndIsNotBlockedTriggeredAbility(Effect effect, boolean optional, SetTargetPointer setTargetPointer) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever {this} attacks and isn't blocked, ");
        this.withRuleTextReplacement(true);
    }

    protected AttacksAndIsNotBlockedTriggeredAbility(AttacksAndIsNotBlockedTriggeredAbility ability) {
        super(ability);
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public AttacksAndIsNotBlockedTriggeredAbility copy() {
        return new AttacksAndIsNotBlockedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNBLOCKED_ATTACKER;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        switch (this.setTargetPointer) {
            case NONE: {
                break;
            }
            case PLAYER: {
                this.getEffects().setTargetPointer(new FixedTarget(game.getCombat().getDefendingPlayerId(this.getSourceId(), game), game));
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong code usage: not supported setTargetPointer");
            }
        }
        return true;
    }
}

