/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class AttacksCreatureYouControlTriggeredAbility
extends TriggeredAbilityImpl {
    protected final FilterPermanent filter;
    protected final boolean setTargetPointer;
    protected boolean once = false;

    public AttacksCreatureYouControlTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public AttacksCreatureYouControlTriggeredAbility(Effect effect, boolean optional) {
        this(effect, optional, StaticFilters.FILTER_CONTROLLED_CREATURE);
    }

    public AttacksCreatureYouControlTriggeredAbility(Effect effect, boolean optional, boolean setTargetPointer) {
        this(effect, optional, StaticFilters.FILTER_CONTROLLED_CREATURE, setTargetPointer);
    }

    public AttacksCreatureYouControlTriggeredAbility(Effect effect, boolean optional, FilterPermanent filter) {
        this(effect, optional, filter, false);
    }

    public AttacksCreatureYouControlTriggeredAbility(Effect effect, boolean optional, FilterPermanent filter, boolean setTargetPointer) {
        this(Zone.BATTLEFIELD, effect, optional, filter, setTargetPointer);
    }

    public AttacksCreatureYouControlTriggeredAbility(Zone zone, Effect effect, boolean optional, FilterPermanent filter, boolean setTargetPointer) {
        super(zone, effect, optional);
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever " + CardUtil.addArticle(filter.getMessage()) + " attacks, ");
    }

    private AttacksCreatureYouControlTriggeredAbility(AttacksCreatureYouControlTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.setTargetPointer = ability.setTargetPointer;
        this.once = ability.once;
    }

    public void setOnce(boolean once) {
        this.once = once;
        this.setTriggerPhrase("When" + (once ? " " : "ever ") + CardUtil.addArticle(this.filter.getMessage()) + " attacks, ");
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(event.getSourceId());
        if (this.filter.match(sourcePermanent, this.controllerId, (Ability)this, game)) {
            if (this.setTargetPointer) {
                this.getEffects().setTargetPointer(new FixedTarget(event.getSourceId(), game));
            }
            this.getEffects().setValue("attackerRef", new MageObjectReference(sourcePermanent, game));
            return true;
        }
        return false;
    }

    @Override
    public AttacksCreatureYouControlTriggeredAbility copy() {
        return new AttacksCreatureYouControlTriggeredAbility(this);
    }
}

