/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Optional;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.SaddledMountWatcher;

public class AttacksWhileSaddledTriggeredAbility
extends AttacksTriggeredAbility {
    public AttacksWhileSaddledTriggeredAbility(Effect effect) {
        super(effect);
        this.setTriggerPhrase("Whenever {this} attacks while saddled, ");
        this.addWatcher(new SaddledMountWatcher());
    }

    private AttacksWhileSaddledTriggeredAbility(AttacksWhileSaddledTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public AttacksWhileSaddledTriggeredAbility copy() {
        return new AttacksWhileSaddledTriggeredAbility(this);
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return super.checkTrigger(event, game) && Optional.ofNullable(this.getSourcePermanentIfItStillExists(game)).map(p -> SaddledMountWatcher.hasBeenSaddledThisTurn(new MageObjectReference((MageObject)p, game), game)).orElse(false) != false;
    }
}

