/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.util.CardUtil;

public class AttacksWithCreaturesTriggeredAbility
extends TriggeredAbilityImpl {
    public static final String VALUEKEY_NUMBER_ATTACKERS = "number_attackers";
    public static final String VALUEKEY_NUMBER_DEFENDING_PLAYERS = "number_defending_players";
    private final FilterPermanent filter;
    private final int minAttackers;
    private final boolean setTargetPointer;

    public AttacksWithCreaturesTriggeredAbility(Effect effect, int minAttackers) {
        this(effect, minAttackers, StaticFilters.FILTER_PERMANENT_CREATURES);
    }

    public AttacksWithCreaturesTriggeredAbility(Effect effect, int minAttackers, FilterPermanent filter) {
        this(Zone.BATTLEFIELD, effect, minAttackers, filter);
    }

    public AttacksWithCreaturesTriggeredAbility(Zone zone, Effect effect, int minAttackers, FilterPermanent filter) {
        this(zone, effect, minAttackers, filter, false);
    }

    public AttacksWithCreaturesTriggeredAbility(Zone zone, Effect effect, int minAttackers, FilterPermanent filter, boolean setTargetPointer) {
        this(zone, effect, minAttackers, filter, setTargetPointer, false);
    }

    public AttacksWithCreaturesTriggeredAbility(Zone zone, Effect effect, int minAttackers, FilterPermanent filter, boolean setTargetPointer, boolean optional) {
        super(zone, effect, optional);
        this.filter = filter;
        this.minAttackers = minAttackers;
        this.setTargetPointer = setTargetPointer;
        if (minAttackers == 1 && StaticFilters.FILTER_PERMANENT_CREATURES.equals(filter)) {
            this.setTriggerPhrase("Whenever you attack, ");
        } else {
            this.setTriggerPhrase("Whenever you attack with " + CardUtil.numberToText(minAttackers) + " or more " + filter.getMessage() + ", ");
        }
    }

    protected AttacksWithCreaturesTriggeredAbility(AttacksWithCreaturesTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.minAttackers = ability.minAttackers;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public AttacksWithCreaturesTriggeredAbility copy() {
        return new AttacksWithCreaturesTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(game.getCombat().getAttackingPlayerId())) {
            return false;
        }
        List attackers = game.getCombat().getAttackers().stream().map(game::getPermanent).filter(Objects::nonNull).filter(permanent -> this.filter.match((Permanent)permanent, this.controllerId, (Ability)this, game)).collect(Collectors.toList());
        if (attackers.size() < this.minAttackers) {
            return false;
        }
        this.getEffects().setValue(VALUEKEY_NUMBER_ATTACKERS, attackers.size());
        this.getEffects().setValue(VALUEKEY_NUMBER_DEFENDING_PLAYERS, attackers.stream().map(MageItem::getId).map(game.getCombat()::getDefenderId).distinct().map(game::getPlayer).filter(Objects::nonNull).mapToInt(x -> 1).sum());
        if (this.setTargetPointer) {
            this.getEffects().setTargetPointer(new FixedTargets(new ArrayList(attackers), game));
        }
        return true;
    }
}

