/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class AuraAttachedTriggeredAbility
extends TriggeredAbilityImpl {
    public AuraAttachedTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever an Aura becomes attached to {this}, ");
    }

    protected AuraAttachedTriggeredAbility(AuraAttachedTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACHED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attachment;
        return event.getTargetId().equals(this.getSourceId()) && (attachment = game.getPermanent(event.getSourceId())) != null && attachment.hasSubtype(SubType.AURA, game);
    }

    @Override
    public AuraAttachedTriggeredAbility copy() {
        return new AuraAttachedTriggeredAbility(this);
    }
}

