/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.AttachmentType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class BlocksOrBlockedByCreatureAttachedTriggeredAbility
extends TriggeredAbilityImpl {
    private final AttachmentType attachmentType;
    private final boolean selfTarget;

    public BlocksOrBlockedByCreatureAttachedTriggeredAbility(Effect effect, AttachmentType attachmentType, boolean selfTarget) {
        this(effect, attachmentType, selfTarget, false);
    }

    public BlocksOrBlockedByCreatureAttachedTriggeredAbility(Effect effect, AttachmentType attachmentType, boolean selfTarget, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever " + attachmentType.verb().toLowerCase() + " creature blocks or becomes blocked by a creature, ");
        this.attachmentType = attachmentType;
        this.selfTarget = selfTarget;
    }

    protected BlocksOrBlockedByCreatureAttachedTriggeredAbility(BlocksOrBlockedByCreatureAttachedTriggeredAbility ability) {
        super(ability);
        this.attachmentType = ability.attachmentType;
        this.selfTarget = ability.selfTarget;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent blockingCreature = game.getPermanent(event.getSourceId());
        Permanent blockedCreature = game.getPermanent(event.getTargetId());
        Permanent attachment = game.getPermanent(this.sourceId);
        if (attachment == null || blockingCreature == null || blockedCreature == null) {
            return false;
        }
        Permanent attachedCreature = game.getPermanent(attachment.getAttachedTo());
        if (attachedCreature == null) {
            return false;
        }
        if (!this.selfTarget) {
            if (blockedCreature.equals(attachedCreature)) {
                this.getEffects().setTargetPointer(new FixedTarget(blockingCreature, game));
                return true;
            }
            if (blockingCreature.equals(attachedCreature)) {
                this.getEffects().setTargetPointer(new FixedTarget(blockedCreature, game));
                return true;
            }
        } else {
            if (blockedCreature.equals(attachedCreature)) {
                this.getEffects().setTargetPointer(new FixedTarget(blockedCreature, game));
                return true;
            }
            if (blockingCreature.equals(attachedCreature)) {
                this.getEffects().setTargetPointer(new FixedTarget(blockingCreature, game));
                return true;
            }
        }
        return false;
    }

    @Override
    public BlocksOrBlockedByCreatureAttachedTriggeredAbility copy() {
        return new BlocksOrBlockedByCreatureAttachedTriggeredAbility(this);
    }
}

