/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.common.CastFromGraveyardOnceWatcher;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CastFromGraveyardOnceEffect
extends AsThoughEffectImpl {
    private final FilterCard filter;
    private final Cost additionalCost;
    private final MageIdentifier mageIdentifier;

    CastFromGraveyardOnceEffect(FilterCard filter, Cost additionalCost, MageIdentifier mageIdentifier) {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.filter = filter;
        this.staticText = "Once during each of your turns, you may cast " + filter.getMessage() + (filter.getMessage().contains("your graveyard") ? "" : " from your graveyard") + (additionalCost == null ? "" : " by " + additionalCost.getText() + " in addition to paying its other costs.");
        this.additionalCost = additionalCost;
        this.mageIdentifier = mageIdentifier;
    }

    private CastFromGraveyardOnceEffect(CastFromGraveyardOnceEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.additionalCost = effect.additionalCost;
        this.mageIdentifier = effect.mageIdentifier;
    }

    @Override
    public CastFromGraveyardOnceEffect copy() {
        return new CastFromGraveyardOnceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        throw new IllegalArgumentException("Wrong code usage: can't call applies method on empty affectedAbility");
    }

    @Override
    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        CastFromGraveyardOnceWatcher watcher = game.getState().getWatcher(CastFromGraveyardOnceWatcher.class);
        Card cardToCast = game.getCard(objectId);
        if (!(controller != null && sourcePermanent != null && watcher != null && cardToCast != null && game.isActivePlayer(playerId) && source.isControlledBy(playerId) && Zone.GRAVEYARD.equals((Object)game.getState().getZone(objectId)) && cardToCast.getOwnerId().equals(playerId) && affectedAbility instanceof SpellAbility && !watcher.abilityUsed(new MageObjectReference(sourcePermanent, game)))) {
            return false;
        }
        SpellAbility spellAbility = (SpellAbility)affectedAbility;
        Card cardToCheck = spellAbility.getCharacteristics(game);
        if (spellAbility.getManaCosts().isEmpty()) {
            return false;
        }
        Set<MageIdentifier> allowedToBeCastNow = spellAbility.spellCanBeActivatedNow(playerId, game);
        if (!allowedToBeCastNow.contains((Object)MageIdentifier.Default) || !this.filter.match(cardToCheck, playerId, source, game)) {
            return false;
        }
        if (this.additionalCost != null) {
            CostsImpl<Cost> costs = new CostsImpl<Cost>();
            costs.add(this.additionalCost);
            controller.setCastSourceIdWithAlternateMana(objectId, spellAbility.getManaCosts(), costs, this.mageIdentifier);
        }
        return true;
    }
}

