/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.SpellCastValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.SetTargetPointer;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.watchers.common.CastSpellLastTurnWatcher;

public class CastSecondSpellTriggeredAbility
extends TriggeredAbilityImpl {
    private static final Hint hint = new ValueHint("Spells you cast this turn", SpellCastValue.instance);
    private final TargetController targetController;
    private final SetTargetPointer setTargetPointer;

    public CastSecondSpellTriggeredAbility(Effect effect) {
        this(effect, TargetController.YOU);
    }

    public CastSecondSpellTriggeredAbility(Effect effect, TargetController targetController) {
        this(Zone.BATTLEFIELD, effect, targetController, false);
    }

    public CastSecondSpellTriggeredAbility(Zone zone, Effect effect, TargetController targetController, boolean optional) {
        this(zone, effect, targetController, optional, SetTargetPointer.NONE);
    }

    public CastSecondSpellTriggeredAbility(Zone zone, Effect effect, TargetController targetController, boolean optional, SetTargetPointer setTargetPointer) {
        super(zone, effect, optional);
        if (targetController == TargetController.YOU) {
            this.addHint(hint);
        }
        this.targetController = targetController;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    protected CastSecondSpellTriggeredAbility(CastSecondSpellTriggeredAbility ability) {
        super(ability);
        this.targetController = ability.targetController;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        CastSpellLastTurnWatcher watcher;
        switch (this.targetController) {
            case YOU: {
                if (this.isControlledBy(event.getPlayerId())) break;
                return false;
            }
            case OPPONENT: {
                if (game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) break;
                return false;
            }
            case ACTIVE: {
                if (!game.isActivePlayer(event.getPlayerId())) {
                    return false;
                }
            }
            case ANY: {
                break;
            }
            default: {
                throw new IllegalArgumentException("TargetController " + (Object)((Object)this.targetController) + " not supported");
            }
        }
        if ((watcher = game.getState().getWatcher(CastSpellLastTurnWatcher.class)) != null && watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(event.getPlayerId()) == 2) {
            this.getEffects().setValue("spellCast", game.getSpell(event.getTargetId()));
            switch (this.setTargetPointer) {
                case PLAYER: {
                    this.getEffects().setTargetPointer(new FixedTarget(event.getPlayerId()));
                    break;
                }
                case SPELL: {
                    this.getEffects().setTargetPointer(new FixedTarget(event.getTargetId()));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("SetTargetPointer " + (Object)((Object)this.setTargetPointer) + " not supported");
                }
            }
            return true;
        }
        return false;
    }

    private String generateTriggerPhrase() {
        switch (this.targetController) {
            case YOU: {
                return "Whenever you cast your second spell each turn, ";
            }
            case OPPONENT: {
                return "Whenever an opponent casts their second spell each turn, ";
            }
            case ACTIVE: {
                return "Whenever a player casts their second spell during their turn, ";
            }
            case ANY: {
                return "Whenever a player casts their second spell each turn, ";
            }
        }
        throw new IllegalArgumentException("TargetController " + (Object)((Object)this.targetController) + " not supported");
    }

    @Override
    public CastSecondSpellTriggeredAbility copy() {
        return new CastSecondSpellTriggeredAbility(this);
    }
}

