/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

public class DealsDamageToAPlayerAttachedTriggeredAbility
extends TriggeredAbilityImpl {
    private final boolean setFixedTargetPointer;
    private final String attachedDescription;
    private final boolean onlyCombat;
    private final TargetController targetController;

    public DealsDamageToAPlayerAttachedTriggeredAbility(Effect effect, String attachedDescription, boolean optional) {
        this(effect, attachedDescription, optional, false);
    }

    public DealsDamageToAPlayerAttachedTriggeredAbility(Effect effect, String attachedDescription, boolean optional, boolean setFixedTargetPointer) {
        this(effect, attachedDescription, optional, setFixedTargetPointer, true);
    }

    public DealsDamageToAPlayerAttachedTriggeredAbility(Effect effect, String attachedDescription, boolean optional, boolean setFixedTargetPointer, boolean onlyCombat) {
        this(effect, attachedDescription, optional, setFixedTargetPointer, onlyCombat, TargetController.ANY);
    }

    public DealsDamageToAPlayerAttachedTriggeredAbility(Effect effect, String attachedDescription, boolean optional, boolean setFixedTargetPointer, boolean onlyCombat, TargetController targetController) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setFixedTargetPointer = setFixedTargetPointer;
        this.attachedDescription = attachedDescription;
        this.targetController = targetController;
        this.onlyCombat = onlyCombat;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    protected DealsDamageToAPlayerAttachedTriggeredAbility(DealsDamageToAPlayerAttachedTriggeredAbility ability) {
        super(ability);
        this.setFixedTargetPointer = ability.setFixedTargetPointer;
        this.attachedDescription = ability.attachedDescription;
        this.onlyCombat = ability.onlyCombat;
        this.targetController = ability.targetController;
    }

    @Override
    public DealsDamageToAPlayerAttachedTriggeredAbility copy() {
        return new DealsDamageToAPlayerAttachedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event instanceof DamagedPlayerEvent;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Player controller;
        if (!(this.targetController != TargetController.OPPONENT || (controller = game.getPlayer(this.getControllerId())) != null && game.isOpponent(controller, event.getPlayerId()))) {
            return false;
        }
        if (this.targetController == TargetController.YOU && !this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent p = game.getPermanent(event.getSourceId());
        if (this.onlyCombat && !damageEvent.isCombatDamage() || p == null || !p.getAttachments().contains(this.getSourceId())) {
            return false;
        }
        this.getEffects().setValue("damage", event.getAmount());
        if (this.setFixedTargetPointer) {
            this.getEffects().setTargetPointer(new FixedTarget(event.getPlayerId()));
        }
        return true;
    }

    private String generateTriggerPhrase() {
        StringBuilder sb = new StringBuilder("Whenever ");
        sb.append(this.attachedDescription);
        if (!this.attachedDescription.endsWith("creature")) {
            sb.append(" creature");
        }
        sb.append(" deals");
        if (this.onlyCombat) {
            sb.append(" combat");
        }
        sb.append(" damage to ");
        switch (this.targetController) {
            case OPPONENT: {
                sb.append("an opponent, ");
                break;
            }
            case YOU: {
                sb.append("you, ");
                break;
            }
            case ANY: {
                sb.append("a player, ");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported TargetController in DealsDamageToAPlayerAttachedTriggeredAbility");
            }
        }
        return sb.toString();
    }
}

