/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.common.DealsDamageToACreatureTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;

public class DealsDamageToOneOrMoreCreaturesTriggeredAbility
extends DealsDamageToACreatureTriggeredAbility {
    public DealsDamageToOneOrMoreCreaturesTriggeredAbility(Effect effect, boolean combatOnly, boolean optional, boolean setTargetPointer) {
        super(effect, combatOnly, optional, setTargetPointer);
        this.setTriggerPhrase("Whenever {this} deals " + (combatOnly ? "combat " : "") + "damage to one or more creatures, ");
    }

    public DealsDamageToOneOrMoreCreaturesTriggeredAbility(DealsDamageToOneOrMoreCreaturesTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (super.checkTrigger(event, game)) {
            if (game.getTurnStepType() == PhaseStep.COMBAT_DAMAGE || game.getTurnStepType() == PhaseStep.FIRST_COMBAT_DAMAGE) {
                String stepHash = (String)game.getState().getValue("damageStep" + this.getOriginalId());
                String newStepHash = game.getTurnStepType().toString() + game.getTurnNum();
                if (!newStepHash.equals(stepHash)) {
                    game.getState().setValue("damageStep" + this.getOriginalId(), game.getTurnStepType().toString() + game.getTurnNum());
                    return true;
                }
            } else {
                game.getState().setValue("damageStep" + this.getOriginalId(), null);
                return true;
            }
        }
        return false;
    }

    @Override
    public DealsDamageToOneOrMoreCreaturesTriggeredAbility copy() {
        return new DealsDamageToOneOrMoreCreaturesTriggeredAbility(this);
    }
}

