/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.DrawNthOrNthCardWatcher;
import mage.abilities.dynamicvalue.common.CardsDrawnThisTurnDynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

public class DrawNthOrNthCardTriggeredAbility
extends TriggeredAbilityImpl {
    private static final Hint hint = new ValueHint("Cards drawn this turn", CardsDrawnThisTurnDynamicValue.instance);
    private final TargetController targetController;
    private final int firstCardNumber;
    private final int secondCardNumber;

    public DrawNthOrNthCardTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public DrawNthOrNthCardTriggeredAbility(Effect effect, boolean optional) {
        this(effect, optional, 1);
    }

    public DrawNthOrNthCardTriggeredAbility(Effect effect, boolean optional, int firstCardNumber) {
        this(effect, optional, TargetController.YOU, firstCardNumber);
    }

    public DrawNthOrNthCardTriggeredAbility(Effect effect, boolean optional, TargetController targetController, int firstCardNumber) {
        this(Zone.BATTLEFIELD, effect, optional, targetController, firstCardNumber, 2);
    }

    public DrawNthOrNthCardTriggeredAbility(Zone zone, Effect effect, boolean optional, TargetController targetController, int firstCardNumber, int secondCardNumber) {
        super(zone, effect, optional);
        this.targetController = targetController;
        this.firstCardNumber = firstCardNumber;
        this.secondCardNumber = secondCardNumber;
        if (targetController == TargetController.YOU) {
            this.addHint(hint);
        }
        this.setTriggerPhrase(this.generateTriggerPhrase());
        this.addWatcher(new DrawNthOrNthCardWatcher());
    }

    protected DrawNthOrNthCardTriggeredAbility(DrawNthOrNthCardTriggeredAbility ability) {
        super(ability);
        this.targetController = ability.targetController;
        this.firstCardNumber = ability.firstCardNumber;
        this.secondCardNumber = ability.secondCardNumber;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        int drawnCards;
        switch (this.targetController) {
            case YOU: {
                if (this.isControlledBy(event.getPlayerId())) break;
                return false;
            }
            case ACTIVE: {
                if (game.isActivePlayer(event.getPlayerId())) break;
                return false;
            }
            case OPPONENT: {
                if (game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) break;
                return false;
            }
            case ANY: {
                break;
            }
            default: {
                throw new IllegalArgumentException("TargetController " + (Object)((Object)this.targetController) + " not supported");
            }
        }
        return (drawnCards = DrawNthOrNthCardWatcher.checkEvent(event.getPlayerId(), event.getId(), game) + 1) == this.firstCardNumber || drawnCards == this.secondCardNumber;
    }

    public String generateTriggerPhrase() {
        String numberText = CardUtil.numberToOrdinalText(this.firstCardNumber) + " or " + CardUtil.numberToOrdinalText(this.secondCardNumber);
        switch (this.targetController) {
            case YOU: {
                return "Whenever you draw your " + numberText + " card each turn, ";
            }
            case ACTIVE: {
                return "Whenever a player draws their " + numberText + " card during their turn, ";
            }
            case OPPONENT: {
                return "Whenever an opponent draws their " + numberText + " card each turn, ";
            }
            case ANY: {
                return "Whenever a player draws their " + numberText + " card each turn, ";
            }
        }
        throw new IllegalArgumentException("TargetController " + (Object)((Object)this.targetController) + " not supported");
    }

    @Override
    public DrawNthOrNthCardTriggeredAbility copy() {
        return new DrawNthOrNthCardTriggeredAbility(this);
    }
}

