/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.EnduringGlimmerTypeEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

class EnduringGlimmerReturnEffect
extends OneShotEffect {
    EnduringGlimmerReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "if it was a creature, return it to the battlefield under its owner's control. It's an enchantment";
    }

    private EnduringGlimmerReturnEffect(EnduringGlimmerReturnEffect effect) {
        super(effect);
    }

    @Override
    public EnduringGlimmerReturnEffect copy() {
        return new EnduringGlimmerReturnEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (player == null || card == null) {
            return false;
        }
        game.addEffect(new EnduringGlimmerTypeEffect().setTargetPointer(new FixedTarget(new MageObjectReference(card, game, 1))), source);
        return player.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
    }
}

