/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Arrays;
import java.util.List;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public class EntersBattlefieldTriggeredAbility
extends TriggeredAbilityImpl {
    public static boolean ENABLE_TRIGGER_PHRASE_AUTO_FIX = false;

    public EntersBattlefieldTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public EntersBattlefieldTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.ALL, effect, optional);
        this.withRuleTextReplacement(true);
        this.setTriggerPhrase("When {this} enters, ");
    }

    protected EntersBattlefieldTriggeredAbility(EntersBattlefieldTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.getSourceId())) {
            this.getEffects().setValue("permanentEnteredBattlefield", game.getPermanent(event.getTargetId()));
            return true;
        }
        return false;
    }

    @Override
    public EntersBattlefieldTriggeredAbility copy() {
        return new EntersBattlefieldTriggeredAbility(this);
    }

    @Override
    public EntersBattlefieldTriggeredAbility setTriggerPhrase(String triggerPhrase) {
        super.setTriggerPhrase(triggerPhrase);
        return this;
    }

    public static String getThisObjectDescription(Card card) {
        List<String> parts = Arrays.asList(card.getName().split(","));
        if (parts.size() > 1 && !parts.get(0).contains(" ")) {
            return parts.get(0);
        }
        if (card.getSubtype().contains((Object)SubType.VEHICLE)) {
            return "this Vehicle";
        }
        if (card.getSubtype().contains((Object)SubType.AURA)) {
            return "this Aura";
        }
        if (card.isCreature()) {
            return "this creature";
        }
        if (card.isPlaneswalker()) {
            return "this planeswalker";
        }
        if (card.isLand()) {
            return "this land";
        }
        if (card.isEnchantment()) {
            return "this enchantment";
        }
        if (card.isArtifact()) {
            return "this artifact";
        }
        return "this permanent";
    }

    public static List<String> getPossibleTriggerPhrases() {
        return Arrays.asList("when this creature enters", "when this planeswalker enters", "when this land enters", "when this enchantment enters", "when this artifact enters", "when this permanent enters");
    }
}

