/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.common.EscapesWithEffect;
import mage.abilities.effects.Effect;
import mage.util.CardUtil;

public class EscapesWithAbility
extends EntersBattlefieldAbility {
    private final int counters;
    private final TriggeredAbility triggeredAbility;

    public EscapesWithAbility(int counters) {
        this(counters, null);
    }

    public EscapesWithAbility(int counters, TriggeredAbility triggeredAbility) {
        super((Effect)new EscapesWithEffect(counters, triggeredAbility), false);
        this.counters = counters;
        this.triggeredAbility = triggeredAbility;
    }

    private EscapesWithAbility(EscapesWithAbility ability) {
        super(ability);
        this.counters = ability.counters;
        this.triggeredAbility = ability.triggeredAbility;
    }

    @Override
    public EscapesWithAbility copy() {
        return new EscapesWithAbility(this);
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder("{this} escapes with ");
        if (this.counters > 0) {
            sb.append(CardUtil.numberToText(this.counters, "a"));
            sb.append(" +1/+1 counter");
            sb.append(this.counters > 1 ? Character.valueOf('s') : "");
            sb.append(" on it.");
        }
        if (this.triggeredAbility instanceof DelayedTriggeredAbility) {
            sb.append(" ");
            sb.append(this.triggeredAbility.getRule());
        } else if (this.triggeredAbility != null) {
            sb.append("\"");
            sb.append(this.triggeredAbility.getRule());
            sb.append("\"");
        }
        return sb.toString();
    }
}

