/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.ReadAheadAbility;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

class GainReadAheadAbility
extends SimpleStaticAbility {
    private static final FilterPermanent filter = new FilterPermanent(SubType.SAGA, "Sagas");

    GainReadAheadAbility() {
        super(new GainAbilityControlledEffect(ReadAheadAbility.getInstance(), Duration.WhileOnBattlefield, filter).setText("Sagas you control have read ahead. <i>(As a Saga enters, choose a chapter and start with that many lore counters. Skipped chapters don't trigger.)</i>"));
    }

    private GainReadAheadAbility(GainReadAheadAbility ability) {
        super(ability);
    }

    @Override
    public GainReadAheadAbility copy() {
        return new GainReadAheadAbility(this);
    }

    static boolean checkForAbility(Game game, Ability source) {
        return game.getBattlefield().getActivePermanents(StaticFilters.FILTER_CONTROLLED_PERMANENT, source.getControllerId(), source, game).stream().anyMatch(p -> p.getAbilities(game).containsClass(GainReadAheadAbility.class));
    }
}

