/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GodEternalEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    GodEternalEffect(MageObjectReference mor) {
        super(Outcome.Benefit);
        this.mor = mor;
    }

    private GodEternalEffect(GodEternalEffect effect) {
        super(effect);
        this.mor = effect.mor;
    }

    @Override
    public GodEternalEffect copy() {
        return new GodEternalEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = game.getCard(this.mor.getSourceId());
        if (card == null || card.getZoneChangeCounter(game) - 1 != this.mor.getZoneChangeCounter()) {
            return false;
        }
        return player.putCardOnTopXOfLibrary(card, game, source, 3, true);
    }
}

