/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.LicidEffect;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.EnchantAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCreaturePermanent;

class LicidContinuousEffect
extends ContinuousEffectImpl {
    private final UUID messageId;

    LicidContinuousEffect(UUID messageId) {
        super(Duration.Custom, Outcome.Neutral);
        this.messageId = messageId;
        this.dependencyTypes.add(DependencyType.AuraAddingRemoving);
    }

    LicidContinuousEffect(LicidContinuousEffect ability) {
        super(ability);
        this.messageId = ability.messageId;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent licid = source.getSourcePermanentIfItStillExists(game);
        if (licid != null) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    licid.removeAllCardTypes(game);
                    licid.addCardType(game, CardType.ENCHANTMENT);
                    licid.removeAllSubTypes(game);
                    licid.addSubType(game, SubType.AURA);
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    Ability ability2;
                    ArrayList<Ability> toRemove = new ArrayList<Ability>();
                    block4: for (Ability ability2 : licid.getAbilities(game)) {
                        for (Effect effect : ability2.getEffects()) {
                            if (!(effect instanceof LicidEffect)) continue;
                            toRemove.add(ability2);
                            continue block4;
                        }
                    }
                    licid.removeAbilities(toRemove, source.getSourceId(), game);
                    TargetCreaturePermanent target = new TargetCreaturePermanent();
                    ability2 = new EnchantAbility(target);
                    ability2.setRuleAtTheTop(true);
                    licid.addAbility(ability2, source.getSourceId(), game);
                    licid.getSpellAbility().getTargets().clear();
                    licid.getSpellAbility().getTargets().add(target);
                }
            }
            return true;
        }
        this.discard();
        return false;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }

    @Override
    public boolean isInactive(Ability source, Game game) {
        Object object = game.getState().getValue(this.messageId.toString());
        return object != null;
    }

    @Override
    public LicidContinuousEffect copy() {
        return new LicidContinuousEffect(this);
    }
}

