/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.util.CardUtil;

public class LinkedEffectIdStaticAbility
extends SimpleStaticAbility {
    private UUID linkedHandshake = UUID.randomUUID();

    public LinkedEffectIdStaticAbility(ChildEffect effect) {
        this(Zone.BATTLEFIELD, effect);
    }

    public LinkedEffectIdStaticAbility(Zone zone, ChildEffect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.initHandshake();
        this.setEffectIdManually();
    }

    private LinkedEffectIdStaticAbility(LinkedEffectIdStaticAbility effect) {
        super(effect);
        this.initHandshake();
    }

    @Override
    public LinkedEffectIdStaticAbility copy() {
        return new LinkedEffectIdStaticAbility(this);
    }

    private void initHandshake() {
        this.linkedHandshake = UUID.randomUUID();
        CardUtil.castStream(this.getEffects().stream(), ChildEffect.class).filter(Objects::nonNull).forEach(e -> e.setParentLinkHandshake(this.linkedHandshake));
    }

    public void setEffectIdManually() {
        CardUtil.castStream(this.getEffects().stream(), ChildEffect.class).filter(Objects::nonNull).forEach(e -> e.manualNewId());
    }

    public boolean checkLinked(UUID handshake) {
        return this.linkedHandshake.equals(handshake);
    }

    @Override
    public void newId() {
        super.newId();
    }

    public static interface ChildEffect
    extends Effect {
        public void setParentLinkHandshake(UUID var1);

        public void manualNewId();
    }
}

