/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MayPay2LifeEffect
extends CostModificationEffectImpl {
    private final ObjectColor color;
    private final ManaCosts<ManaCost> manaCost;

    MayPay2LifeEffect(ObjectColor color) {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.color = color;
        this.manaCost = new ManaCostsImpl<ManaCost>("{" + color + "}");
    }

    private MayPay2LifeEffect(MayPay2LifeEffect effect) {
        super(effect);
        this.color = effect.color;
        this.manaCost = effect.manaCost;
    }

    @Override
    public MayPay2LifeEffect copy() {
        return new MayPay2LifeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player player = game.getPlayer(abilityToModify.getControllerId());
        PayLifeCost cost = new PayLifeCost(2);
        if (!cost.canPay(abilityToModify, source, source.getControllerId(), game)) {
            return true;
        }
        if (game.inCheckPlayableState() || player.chooseUse(this.outcome, "Pay 2 life to reduce the cost by {" + this.color + "}?", source, game) && cost.pay(abilityToModify, game, source, source.getControllerId(), true)) {
            CardUtil.adjustCost((SpellAbility)abilityToModify, this.manaCost, false);
        }
        return true;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility) || !abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        Card spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
        return spellCard.isPermanent(game) && spellCard.getColor(game).contains(this.color);
    }
}

