/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class PutIntoGraveFromBattlefieldAllTriggeredAbility
extends TriggeredAbilityImpl {
    private final FilterPermanent filter;
    private final boolean setTargetPointer;
    private final boolean onlyToControllerGraveyard;

    public PutIntoGraveFromBattlefieldAllTriggeredAbility(Effect effect, boolean optional, FilterPermanent filter, boolean setTargetPointer) {
        this(effect, optional, filter, setTargetPointer, false);
    }

    public PutIntoGraveFromBattlefieldAllTriggeredAbility(Effect effect, boolean optional, FilterPermanent filter, boolean setTargetPointer, boolean onlyToControllerGraveyard) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setLeavesTheBattlefieldTrigger(true);
        this.filter = filter;
        this.onlyToControllerGraveyard = onlyToControllerGraveyard;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever " + CardUtil.addArticle(filter.getMessage()) + " is put into " + (onlyToControllerGraveyard ? "your" : "a") + " graveyard from the battlefield, ");
    }

    protected PutIntoGraveFromBattlefieldAllTriggeredAbility(PutIntoGraveFromBattlefieldAllTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.onlyToControllerGraveyard = ability.onlyToControllerGraveyard;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent() || !this.filter.match(zEvent.getTarget(), this.getControllerId(), (Ability)this, game) || this.onlyToControllerGraveyard && !this.isControlledBy(game.getOwnerId(zEvent.getTargetId()))) {
            return false;
        }
        this.getEffects().setValue("permanentDied", zEvent.getTarget());
        if (this.setTargetPointer) {
            this.getEffects().setTargetPointer(new FixedTarget(event.getTargetId(), game.getObject(event.getTargetId()).getZoneChangeCounter(game)));
        }
        return true;
    }

    @Override
    public PutIntoGraveFromBattlefieldAllTriggeredAbility copy() {
        return new PutIntoGraveFromBattlefieldAllTriggeredAbility(this);
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger(this, sourceObject, event, game);
    }
}

