/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ReturnSourceAttachedToItEffect
extends OneShotEffect {
    ReturnSourceAttachedToItEffect() {
        super(Outcome.Benefit);
        this.staticText = "return this card from your graveyard to the battlefield attached to that creature";
    }

    private ReturnSourceAttachedToItEffect(ReturnSourceAttachedToItEffect effect) {
        super(effect);
    }

    @Override
    public ReturnSourceAttachedToItEffect copy() {
        return new ReturnSourceAttachedToItEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card sourceCard = source.getSourceCardIfItStillExists(game);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (sourceCard != null && permanent != null && controller != null) {
            game.getState().setValue("attachTo:" + sourceCard.getId(), permanent);
            if (controller.moveCards(sourceCard, Zone.BATTLEFIELD, source, game)) {
                permanent.addAttachment(sourceCard.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

