/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.common.GainReadAheadAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.ReadAheadAbility;
import mage.constants.Outcome;
import mage.constants.SagaChapter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SagaLoreCountersEffect
extends OneShotEffect {
    private final SagaChapter maxChapter;

    SagaLoreCountersEffect(SagaChapter maxChapter) {
        super(Outcome.Benefit);
        this.maxChapter = maxChapter;
    }

    private SagaLoreCountersEffect(SagaLoreCountersEffect effect) {
        super(effect);
        this.maxChapter = effect.maxChapter;
    }

    @Override
    public SagaLoreCountersEffect copy() {
        return new SagaLoreCountersEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        if (!permanent.hasAbility(ReadAheadAbility.getInstance(), game) && !GainReadAheadAbility.checkForAbility(game, source)) {
            return permanent.addCounters(CounterType.LORE.createInstance(), source, game);
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int counters = player.getAmount(1, this.maxChapter.getNumber(), "Choose the number of lore counters to enter with", source, game);
        return permanent.addCounters(CounterType.LORE.createInstance(counters), source, game);
    }
}

