/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.common.SpellTransformedAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SiegeDefeatedEffect
extends OneShotEffect {
    SiegeDefeatedEffect() {
        super(Outcome.Benefit);
    }

    private SiegeDefeatedEffect(SiegeDefeatedEffect effect) {
        super(effect);
    }

    @Override
    public SiegeDefeatedEffect copy() {
        return new SiegeDefeatedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        Card card = permanent.getMainCard();
        player.moveCards(permanent, Zone.EXILED, source, game);
        if (card == null || card.getSecondFaceSpellAbility() == null) {
            return true;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getSecondCardFace().getId(), Boolean.TRUE);
        SpellTransformedAbility transformedSpell = new SpellTransformedAbility(card.getSecondFaceSpellAbility());
        player.cast(transformedSpell, game, true, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getSecondCardFace().getId(), null);
        return true;
    }
}

