/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class TapForManaAllTriggeredAbility
extends TriggeredAbilityImpl {
    private final FilterPermanent filter;
    private final SetTargetPointer setTargetPointer;

    public TapForManaAllTriggeredAbility(Effect effect, FilterPermanent filter, SetTargetPointer setTargetPointer) {
        this(effect, filter, setTargetPointer, false);
    }

    public TapForManaAllTriggeredAbility(Effect effect, FilterPermanent filter, SetTargetPointer setTargetPointer, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever " + filter.getMessage() + " for mana, ");
    }

    private TapForManaAllTriggeredAbility(TapForManaAllTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter.copy();
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        TappedForManaEvent manaEvent = (TappedForManaEvent)event;
        Permanent permanent = manaEvent.getPermanent();
        if (permanent == null || !this.filter.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        this.getEffects().setValue("mana", manaEvent.getMana());
        this.getEffects().setValue("tappedPermanent", permanent);
        switch (this.setTargetPointer) {
            case PERMANENT: {
                this.getEffects().setTargetPointer(new FixedTarget(permanent.getId(), permanent.getZoneChangeCounter(game)));
                break;
            }
            case PLAYER: {
                this.getEffects().setTargetPointer(new FixedTarget(permanent.getControllerId()));
            }
        }
        return true;
    }

    @Override
    public TapForManaAllTriggeredAbility copy() {
        return new TapForManaAllTriggeredAbility(this);
    }
}

