/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

public class ZoneChangeAllTriggeredAbility
extends TriggeredAbilityImpl {
    protected final FilterPermanent filter;
    protected final Zone fromZone;
    protected final Zone toZone;

    public ZoneChangeAllTriggeredAbility(Zone zone, Zone toZone, Effect effect, FilterPermanent filter, String triggerPhrase, boolean optional) {
        this(zone, null, toZone, effect, filter, triggerPhrase, optional);
    }

    public ZoneChangeAllTriggeredAbility(Zone zone, Zone fromZone, Zone toZone, Effect effect, FilterPermanent filter, String triggerPhrase, boolean optional) {
        super(zone, effect, optional);
        if (fromZone == Zone.BATTLEFIELD) {
            this.setLeavesTheBattlefieldTrigger(true);
        }
        this.fromZone = fromZone;
        this.toZone = toZone;
        this.filter = filter;
        this.setTriggerPhrase(triggerPhrase);
    }

    protected ZoneChangeAllTriggeredAbility(ZoneChangeAllTriggeredAbility ability) {
        super(ability);
        this.fromZone = ability.fromZone;
        this.toZone = ability.toZone;
        this.filter = ability.filter;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent perm;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return !(this.fromZone != null && !this.fromZone.match(zEvent.getFromZone()) || this.toZone != null && !this.toZone.match(zEvent.getToZone()) || !this.filter.match(perm = zEvent.getTarget() != null ? zEvent.getTarget() : game.getPermanent(event.getTargetId()), this.controllerId, (Ability)this, game));
    }

    @Override
    public ZoneChangeAllTriggeredAbility copy() {
        return new ZoneChangeAllTriggeredAbility(this);
    }

    public Zone getFromZone() {
        return this.fromZone;
    }

    public Zone getToZone() {
        return this.toZone;
    }
}

