/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.ComparisonType;
import mage.game.Game;
import mage.players.Player;

public class CardsInAnyLibraryCondition
implements Condition {
    protected final ComparisonType type;
    protected final int value;

    public CardsInAnyLibraryCondition(ComparisonType type, int value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public final boolean apply(Game game, Ability source) {
        boolean libraryWith20OrFewerCards = false;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !ComparisonType.compare(player.getLibrary().size(), this.type, this.value)) continue;
                libraryWith20OrFewerCards = true;
                break;
            }
        }
        return libraryWith20OrFewerCards;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("a library has ");
        switch (this.type) {
            case MORE_THAN: {
                sb.append(this.value + 1).append(" or more cards in it ");
                break;
            }
            case EQUAL_TO: {
                sb.append(this.value).append(" cards in it ");
                break;
            }
            case FEWER_THAN: {
                sb.append(this.value - 1).append(" or fewer cards in it ");
            }
        }
        return sb.toString();
    }
}

