/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class CardsInControllerGraveyardCondition
implements Condition {
    private final int value;
    private final FilterCard filter;

    public CardsInControllerGraveyardCondition(int value) {
        this(value, null);
    }

    public CardsInControllerGraveyardCondition(int value, FilterCard filter) {
        this.value = value;
        this.filter = filter;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (this.filter != null) {
            return player != null && player.getGraveyard().count(this.filter, source.getControllerId(), source, game) >= this.value;
        }
        return player != null && player.getGraveyard().size() >= this.value;
    }

    public String toString() {
        return "there are " + CardUtil.numberToText(this.value, "one") + " or more " + (this.filter == null ? "cards" : this.filter.getMessage()) + " in your graveyard";
    }
}

