/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.PermanentsEnteredBattlefieldWatcher;

enum CelebrationNonlandsThatEnteredThisTurnCount implements DynamicValue
{
    instance;


    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        PermanentsEnteredBattlefieldWatcher watcher = game.getState().getWatcher(PermanentsEnteredBattlefieldWatcher.class);
        if (watcher != null) {
            List<Permanent> list = watcher.getThisTurnEnteringPermanents(sourceAbility.getControllerId());
            return (int)list.stream().filter(x -> !x.isLand(game)).count();
        }
        return 0;
    }

    @Override
    public DynamicValue copy() {
        return instance;
    }

    @Override
    public String getMessage() {
        return "nonland permanents that entered under your control this turn";
    }
}

