/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.CommanderCardType;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

public enum ControlYourCommanderCondition implements Condition
{
    instance;


    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) return false;
        if (!game.getCommandersIds(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, true).stream().map(game::getPermanent).filter(Objects::nonNull).map(Controllable::getControllerId).anyMatch(source::isControlledBy)) return false;
        return true;
    }

    public String toString() {
        return "you control your commander";
    }
}

