/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.ComparisonType;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class CountersOnPermanentsCondition
implements Condition {
    public final FilterPermanent filter;
    public final CounterType counterType;
    public final ComparisonType comparisonType;
    public final int threshold;

    public CountersOnPermanentsCondition(FilterPermanent filter, CounterType counterType, ComparisonType comparisonType, int threshold) {
        this.filter = filter;
        this.counterType = counterType;
        this.comparisonType = comparisonType;
        this.threshold = threshold;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int totalCounters = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
            for (Counter counter : permanent.getCounters(game).values()) {
                if (!counter.getName().equals(this.counterType.getName()) || !ComparisonType.compare(totalCounters += counter.getCount(), this.comparisonType, this.threshold)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String comparisonText;
        switch (this.comparisonType) {
            case MORE_THAN: {
                comparisonText = String.format("%d or more", this.threshold + 1);
                break;
            }
            case EQUAL_TO: {
                comparisonText = String.format("%d or fewer", this.threshold - 1);
                break;
            }
            case FEWER_THAN: {
                comparisonText = String.format("%d", this.threshold);
                break;
            }
            default: {
                throw new IllegalArgumentException("comparison rules for " + (Object)((Object)this.comparisonType) + " missing");
            }
        }
        return "there are " + comparisonText + this.counterType.getName() + " counters among " + this.filter.getMessage();
    }
}

