/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public enum EquippedSourceCondition implements Condition
{
    instance;


    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            for (UUID uuid : permanent.getAttachments()) {
                Permanent attached = game.getPermanent(uuid);
                if (attached == null || !attached.hasSubtype(SubType.EQUIPMENT, game)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "{this} is equipped";
    }
}

