/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;

public enum IsMainPhaseCondition implements Condition
{
    YOUR(true),
    ANY(false);

    private final boolean yourMainPhaseOnly;

    private IsMainPhaseCondition(boolean yourMainPhaseOnly) {
        this.yourMainPhaseOnly = yourMainPhaseOnly;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return game.getTurnPhaseType().isMain() && (!this.yourMainPhaseOnly || game.getActivePlayerId().equals(source.getControllerId()));
    }

    public String toString() {
        return "it's" + (this.yourMainPhaseOnly ? " your " : " ") + "main phase";
    }
}

