/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.keyword.KickerAbility;
import mage.game.Game;

public enum KickedCondition implements Condition
{
    ONCE(1, ""),
    TWICE(2, "twice");

    private final int kickedCount;
    private final String text;

    private KickedCondition(int kickedCount, String text) {
        this.kickedCount = kickedCount;
        this.text = text;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return KickerAbility.getKickedCounter(game, source) >= this.kickedCount;
    }

    public String toString() {
        return "it was kicked" + (this.text.isEmpty() ? "" : " " + this.text);
    }
}

