/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.game.Game;
import mage.watchers.common.PermanentsSacrificedWatcher;

public enum SacrificedArtifactThisTurnCondition implements Condition
{
    instance;

    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return Optional.ofNullable(game.getState().getWatcher(PermanentsSacrificedWatcher.class).getThisTurnSacrificedPermanents(source.getControllerId())).map(Collection::stream).orElseGet(Stream::empty).anyMatch(permanent -> permanent.isArtifact(game));
    }

    public String toString() {
        return "you've sacrificed an artifact this turn";
    }

    static {
        hint = new ConditionHint(instance, "You sacrificed an artifact this turn");
    }
}

