/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.game.permanent.Permanent;

public enum SolvedSourceCondition implements Condition
{
    SOLVED(true),
    UNSOLVED(false);

    private final boolean solved;

    private SolvedSourceCondition(boolean solved) {
        this.solved = solved;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        return permanent != null && permanent.isSolved() == this.solved;
    }

    public String toString() {
        return "{this} is " + (this.solved ? "solved" : "unsolved");
    }
}

