/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.condition.IntCompareCondition;
import mage.constants.ComparisonType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class SourceHasCounterCondition
extends IntCompareCondition {
    private final CounterType counterType;

    public SourceHasCounterCondition(CounterType counterType) {
        this(counterType, 1);
    }

    public SourceHasCounterCondition(CounterType counterType, int amount) {
        this(counterType, ComparisonType.OR_GREATER, amount);
    }

    public SourceHasCounterCondition(CounterType counterType, ComparisonType type, int value) {
        super(type, value);
        this.counterType = counterType;
    }

    @Override
    protected int getInputValue(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent != null) {
            return permanent.getCounters(game).getCount(this.counterType);
        }
        return Optional.ofNullable(source).map(Ability::getSourceId).map(game::getCard).map(card -> card.getCounters(game).getCount(this.counterType)).orElse(0);
    }

    @Override
    public String toString() {
        switch (this.type) {
            case EQUAL_TO: {
                StringBuilder sb = new StringBuilder("there ");
                switch (this.value) {
                    case 0: {
                        sb.append("are no ");
                        break;
                    }
                    case 1: {
                        sb.append("is exactly one ");
                        break;
                    }
                    default: {
                        sb.append("are exactly ");
                        sb.append(CardUtil.numberToText(this.value));
                        sb.append(' ');
                    }
                }
                sb.append(this.counterType.getName());
                sb.append(" counter");
                if (this.value != 1) {
                    sb.append('s');
                }
                sb.append(" on {this}");
                return sb.toString();
            }
            case OR_GREATER: {
                if (this.value == 0) {
                    throw new IllegalArgumentException("0 or greater should not be used");
                }
                return "there are " + CardUtil.numberToText(this.value) + " or more " + this.counterType.getName() + " counters on {this}";
            }
            case OR_LESS: {
                return "{this} has " + CardUtil.numberToText(this.value) + " or fewer " + this.counterType.getName() + " counters on it";
            }
            case FEWER_THAN: {
                return "{this} has fewer than " + CardUtil.numberToText(this.value) + ' ' + this.counterType.getName() + " counters on it";
            }
            case MORE_THAN: {
                return "{this} has more than " + CardUtil.numberToText(this.value) + ' ' + this.counterType.getName() + " counters on it";
            }
        }
        throw new UnsupportedOperationException("There should be a comparison type");
    }
}

