/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.cards.Card;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class TargetHasCounterCondition
implements Condition {
    private final CounterType counterType;
    private int amount = 1;
    private int from = -1;
    private int to;

    public TargetHasCounterCondition(CounterType type) {
        this.counterType = type;
    }

    public TargetHasCounterCondition(CounterType type, int amount) {
        this.counterType = type;
        this.amount = amount;
    }

    public TargetHasCounterCondition(CounterType type, int from, int to) {
        this.counterType = type;
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card = null;
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getFirstTarget());
        if (permanent == null && (card = game.getCard(source.getFirstTarget())) == null) {
            return false;
        }
        if (this.from != -1) {
            int count = card != null ? card.getCounters(game).getCount(this.counterType) : permanent.getCounters(game).getCount(this.counterType);
            if (this.to == Integer.MAX_VALUE) {
                return count >= this.from;
            }
            return count >= this.from && count <= this.to;
        }
        if (card != null) {
            return card.getCounters(game).getCount(this.counterType) >= this.amount;
        }
        return permanent.getCounters(game).getCount(this.counterType) >= this.amount;
    }

    public String toString() {
        return "if it has a " + this.counterType.getName() + " on it";
    }
}

