/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.costs.AlternativeCost;
import mage.abilities.costs.AlternativeCostImpl;
import mage.abilities.costs.AlternativeSourceCosts;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.DynamicCost;
import mage.abilities.costs.VariableCost;
import mage.abilities.costs.mana.ManaCost;
import mage.cards.Card;
import mage.constants.AbilityType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class AlternativeCostSourceAbility
extends StaticAbility
implements AlternativeSourceCosts {
    private static final String ALTERNATIVE_COST_ACTIVATION_KEY = "AlternativeCostActivated";
    private static final String ALTERNATIVE_DYNAMIC_COST_ACTIVATED_KEY = "AlternativeDynamicCostActivated";
    private Costs<AlternativeCost> alternateCosts = new CostsImpl<AlternativeCost>();
    protected Condition condition;
    protected String rule;
    protected FilterCard filter;
    protected boolean onlyMana;
    protected DynamicCost dynamicCost;

    public AlternativeCostSourceAbility(Cost cost) {
        this(cost, null);
    }

    public AlternativeCostSourceAbility(Condition conditon) {
        this(null, conditon, null);
    }

    public AlternativeCostSourceAbility(Cost cost, Condition conditon) {
        this(cost, conditon, null);
    }

    public AlternativeCostSourceAbility(Cost cost, Condition condition, String rule) {
        this(cost, condition, rule, null, true);
    }

    public AlternativeCostSourceAbility(Cost cost, Condition condition, String rule, FilterCard filter, boolean onlyMana) {
        super(Zone.ALL, null);
        this.addCost(cost);
        this.setRuleAtTheTop(true);
        this.condition = condition;
        this.rule = rule;
        this.filter = filter;
        this.onlyMana = onlyMana;
    }

    public AlternativeCostSourceAbility(Condition condition, String rule, FilterCard filter, boolean onlyMana, DynamicCost dynamicCost) {
        super(Zone.ALL, null);
        this.setRuleAtTheTop(true);
        this.condition = condition;
        this.rule = rule;
        this.filter = filter;
        this.onlyMana = onlyMana;
        this.dynamicCost = dynamicCost;
    }

    protected AlternativeCostSourceAbility(AlternativeCostSourceAbility ability) {
        super(ability);
        this.alternateCosts = ability.alternateCosts;
        this.condition = ability.condition;
        this.rule = ability.rule;
        this.filter = ability.filter;
        this.onlyMana = ability.onlyMana;
        this.dynamicCost = ability.dynamicCost;
    }

    @Override
    public void addCost(Cost cost) {
        AlternativeCost alternativeCost = this.convertToAlternativeCost(cost);
        if (alternativeCost != null) {
            this.alternateCosts.add(alternativeCost);
        }
    }

    private AlternativeCost convertToAlternativeCost(Cost cost) {
        return cost != null ? new AlternativeCostImpl(null, "", cost) : null;
    }

    @Override
    public AlternativeCostSourceAbility copy() {
        return new AlternativeCostSourceAbility(this);
    }

    @Override
    public boolean isAvailable(Ability source, Game game) {
        boolean conditionApplies = this.condition == null || this.condition.apply(game, source);
        boolean filterApplies = this.filter == null || this.filter.match(game.getCard(source.getSourceId()), game);
        return conditionApplies && filterApplies;
    }

    @Override
    public boolean canActivateAlternativeCostsNow(Ability ability, Game game) {
        Costs<AlternativeCost> alternativeCostsToCheck;
        Card card;
        if (ability == null || !AbilityType.SPELL.equals((Object)ability.getAbilityType())) {
            return this.isActivated(ability, game);
        }
        if (this.filter != null && !this.filter.match(card = game.getCard(ability.getSourceId()), ability.getControllerId(), ability, game)) {
            return false;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return false;
        }
        if (this.dynamicCost != null) {
            alternativeCostsToCheck = new CostsImpl<AlternativeCost>();
            alternativeCostsToCheck.add(this.convertToAlternativeCost(this.dynamicCost.getCost(ability, game)));
        } else {
            alternativeCostsToCheck = this.alternateCosts;
        }
        return alternativeCostsToCheck.canPay(ability, ability, ability.getControllerId(), game);
    }

    @Override
    public String getAlternativeCostText(Ability ability, Game game) {
        Costs<AlternativeCost> alternativeCostsToCheck;
        if (this.dynamicCost != null) {
            return "Cast with alternative cost: " + this.dynamicCost.getText(ability, game) + CardUtil.getSourceLogName(game, this);
        }
        if (this.dynamicCost != null) {
            alternativeCostsToCheck = new CostsImpl<AlternativeCost>();
            alternativeCostsToCheck.add(this.convertToAlternativeCost(this.dynamicCost.getCost(ability, game)));
        } else {
            alternativeCostsToCheck = this.alternateCosts;
        }
        return alternativeCostsToCheck.isEmpty() ? "Cast without paying its mana cost" + CardUtil.getSourceLogName(game, this) : "Cast with alternative cost: " + alternativeCostsToCheck.getText() + CardUtil.getSourceLogName(game, this);
    }

    @Override
    public boolean activateAlternativeCosts(Ability ability, Game game) {
        Costs<AlternativeCost> alternativeCostsToCheck;
        if (this.dynamicCost != null) {
            alternativeCostsToCheck = new CostsImpl<AlternativeCost>();
            alternativeCostsToCheck.add(this.convertToAlternativeCost(this.dynamicCost.getCost(ability, game)));
        } else {
            alternativeCostsToCheck = this.alternateCosts;
        }
        if (ability instanceof SpellAbility) {
            ability.getManaCostsToPay().removeIf(VariableCost.class::isInstance);
            CardUtil.reduceCost((SpellAbility)ability, ability.getManaCosts());
        } else {
            ability.clearManaCostsToPay();
        }
        if (!this.onlyMana) {
            ability.clearCosts();
        }
        for (AlternativeCost alternateCost : alternativeCostsToCheck) {
            alternateCost.activate();
            for (Cost costDetailed : (Costs)((Object)alternateCost)) {
                if (costDetailed instanceof ManaCost) {
                    ability.addManaCostsToPay((ManaCost)costDetailed.copy());
                    continue;
                }
                if (costDetailed == null) continue;
                ability.addCost(costDetailed.copy());
            }
        }
        if (this.dynamicCost != null) {
            this.rememberDynamicCost(game, ability, alternativeCostsToCheck);
        }
        this.doActivate(game, ability);
        return true;
    }

    protected void doActivate(Game game, Ability ability) {
        game.getState().setValue(this.getActivatedKey(ability), Boolean.TRUE);
    }

    private String getActivatedKey(Ability source) {
        return AlternativeCostSourceAbility.getActivatedKey(this.getOriginalId(), source.getSourceId(), source.getStackMomentSourceZCC());
    }

    private static String getActivatedKey(UUID alternativeCostOriginalId, UUID sourceId, int sourceZCC) {
        return "AlternativeCostActivated_" + alternativeCostOriginalId + "_" + sourceZCC;
    }

    private void rememberDynamicCost(Game game, Ability ability, Costs<AlternativeCost> costs) {
        game.getState().setValue(this.getDynamicCostActivatedKey(ability), costs);
    }

    private String getDynamicCostActivatedKey(Ability source) {
        return AlternativeCostSourceAbility.getDynamicCostActivatedKey(this.getOriginalId(), source.getSourceId(), source.getStackMomentSourceZCC());
    }

    private static String getDynamicCostActivatedKey(UUID alternativeCostOriginalId, UUID sourceId, int sourceZCC) {
        return "AlternativeDynamicCostActivated_" + alternativeCostOriginalId + "_" + sourceZCC;
    }

    public static boolean getActivatedStatus(Game game, Ability source, UUID alternativeCostOriginalId, boolean searchPrevZCC) {
        String key = AlternativeCostSourceAbility.getActivatedKey(alternativeCostOriginalId, source.getSourceId(), source.getStackMomentSourceZCC() + (searchPrevZCC ? -1 : 0));
        Boolean status = (Boolean)game.getState().getValue(key);
        return status != null && status != false;
    }

    @Override
    public boolean isActivated(Ability source, Game game) {
        Costs alternativeCostsToCheck;
        Costs costs = alternativeCostsToCheck = this.dynamicCost != null ? (Costs)game.getState().getValue(this.getDynamicCostActivatedKey(source)) : this.alternateCosts;
        if (alternativeCostsToCheck == null) {
            return false;
        }
        for (AlternativeCost cost : alternativeCostsToCheck) {
            if (!cost.isActivated(game)) continue;
            return true;
        }
        return this.onlyMana && alternativeCostsToCheck.isEmpty();
    }

    @Override
    public String getCastMessageSuffix(Game game) {
        return this.alternateCosts.isEmpty() ? " without paying its mana costs" : " using alternative casting costs";
    }

    @Override
    public void resetCost() {
    }

    @Override
    public String getRule() {
        if (this.rule != null) {
            return this.rule;
        }
        StringBuilder sb = new StringBuilder();
        if (this.condition != null) {
            sb.append("if ");
            sb.append(this.condition);
            if (this.alternateCosts.size() > 1) {
                sb.append(", rather than pay this spell's mana cost, ");
            } else {
                sb.append(", you may ");
            }
        } else {
            sb.append("You may ");
        }
        sb.append(CardUtil.concatWithAnd(this.alternateCosts.stream().map(cost -> cost.getCost() instanceof ManaCost ? "pay " + cost.getText(true) : cost.getText(true)).map(CardUtil::getTextWithFirstCharLowerCase).collect(Collectors.toList())));
        if (this.condition == null || this.alternateCosts.size() == 1) {
            sb.append(" rather than pay this spell's mana cost");
        } else if (this.alternateCosts.isEmpty()) {
            sb.append("cast this spell without paying its mana cost");
        }
        sb.append('.');
        return sb.toString();
    }

    @Override
    public Costs<Cost> getCosts() {
        CostsImpl<Cost> alterCosts = new CostsImpl<Cost>();
        alterCosts.addAll(this.alternateCosts);
        return alterCosts;
    }

    public DynamicCost getDynamicCost() {
        return this.dynamicCost;
    }
}

