/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import mage.abilities.costs.Cost;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.VariableCost;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.mana.VariableManaCost;
import mage.util.CardUtil;

public class OptionalAdditionalCostImpl
extends CostsImpl<Cost>
implements OptionalAdditionalCost {
    protected String name;
    protected String reminderText;
    protected String delimiter;
    protected boolean activated;
    protected int activatedCounter;
    protected boolean repeatable;

    public OptionalAdditionalCostImpl(String name, String reminderText, Cost cost) {
        this(name, " ", reminderText, cost);
    }

    public OptionalAdditionalCostImpl(String name, String delimiter, String reminderText, Cost cost) {
        this.activated = false;
        this.name = name;
        this.delimiter = delimiter;
        this.reminderText = "<i>(" + reminderText + ")</i>";
        this.activatedCounter = 0;
        this.add(cost);
    }

    protected OptionalAdditionalCostImpl(OptionalAdditionalCostImpl cost) {
        super(cost);
        this.name = cost.name;
        this.reminderText = cost.reminderText;
        this.delimiter = cost.delimiter;
        this.activated = cost.activated;
        this.activatedCounter = cost.activatedCounter;
        this.repeatable = cost.repeatable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getText(boolean onlyCost) {
        if (onlyCost) {
            return this.getText();
        }
        return this.name + this.delimiter + this.getText() + (this.delimiter.equals("&mdash;") ? "." : "");
    }

    @Override
    public String getReminderText() {
        String replace = "";
        if (this.reminderText != null && !this.reminderText.isEmpty()) {
            replace = this.reminderText.replace("{cost}", CardUtil.getTextWithFirstCharLowerCase(this.getText(true)));
        }
        return replace;
    }

    @Override
    public void setReminderText(String reminderText) {
        this.reminderText = reminderText;
    }

    @Override
    public void setMinimumCost(int minimumCost) {
        for (VariableCost cost : this.getVariableCosts()) {
            if (!(cost instanceof VariableManaCost)) continue;
            ((VariableManaCost)cost).setMinX(minimumCost);
        }
    }

    @Override
    public String getCastSuffixMessage(int position) {
        StringBuilder sb = new StringBuilder();
        if (this.isActivated() && (!this.isRepeatable() || this.getActivateCount() > 0)) {
            sb.append(position > 0 ? " and " : "").append(" with ");
            if (this.isRepeatable()) {
                sb.append(this.getActivateCount()).append(this.getActivateCount() > 1 ? " times " : " time ");
            }
            sb.append(this.name);
        }
        return sb.toString();
    }

    @Override
    public void activate() {
        this.activated = true;
        ++this.activatedCounter;
    }

    @Override
    public void reset() {
        this.activated = false;
        this.activatedCounter = 0;
    }

    @Override
    public void setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public int getActivateCount() {
        return this.activatedCounter;
    }

    @Override
    public void setCostType(VariableCostType costType) {
        this.getVariableCosts().forEach((? super T cost) -> cost.setCostType(costType));
    }

    @Override
    public OptionalAdditionalCostImpl copy() {
        return new OptionalAdditionalCostImpl(this);
    }
}

