/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.game.Game;
import mage.util.ManaUtil;

public class DynamicValueGenericManaCost
extends CostImpl {
    DynamicValue amount;

    public DynamicValueGenericManaCost(DynamicValue amount, String text) {
        this.amount = amount;
        this.setText(text);
    }

    public DynamicValueGenericManaCost(DynamicValueGenericManaCost cost) {
        super(cost);
        this.amount = cost.amount;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        ManaCost cost = ManaUtil.createManaCost(this.amount, game, ability, null);
        return cost.canPay(ability, source, controllerId, game);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        ManaCost cost = ManaUtil.createManaCost(this.amount, game, ability, null);
        this.paid = cost.pay(ability, game, source, controllerId, noMana);
        return this.paid;
    }

    @Override
    public DynamicValueGenericManaCost copy() {
        return new DynamicValueGenericManaCost(this);
    }
}

