/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.mana.VariableManaCost;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

public class ExileFromHandCost
extends CostImpl {
    List<Card> cards = new ArrayList<Card>();
    private final boolean setXFromCMC;

    public ExileFromHandCost(TargetCardInHand target) {
        this(target, false);
    }

    public ExileFromHandCost(TargetCardInHand target, boolean setXFromCMC) {
        this.addTarget(target);
        this.text = "exile " + target.getDescription() + (target.getDescription().contains("from your hand") ? "" : " from your hand");
        this.setXFromCMC = setXFromCMC;
    }

    protected ExileFromHandCost(ExileFromHandCost cost) {
        super(cost);
        for (Card card : cost.cards) {
            this.cards.add(card.copy());
        }
        this.setXFromCMC = cost.setXFromCMC;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.getTargets().choose(Outcome.Exile, controllerId, source.getSourceId(), source, game)) {
            Player player = game.getPlayer(controllerId);
            int cmc = 0;
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Card card = player.getHand().get(targetId, game);
                if (card == null) {
                    return false;
                }
                cmc += card.getManaValue();
                this.cards.add(card);
            }
            CardsImpl cardsToExile = new CardsImpl();
            cardsToExile.addAllCards(this.cards);
            player.moveCards(cardsToExile, Zone.EXILED, ability, game);
            this.paid = true;
            if (this.setXFromCMC) {
                VariableManaCost vmc = new VariableManaCost(VariableCostType.ALTERNATIVE);
                vmc.setAmount(cmc, cmc, false);
                vmc.setPaid();
                ability.addManaCostsToPay(vmc);
            }
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    @Override
    public ExileFromHandCost copy() {
        return new ExileFromHandCost(this);
    }

    public List<Card> getCards() {
        return this.cards;
    }
}

