/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInExile;

public class ExileOpponentsCardFromExileToGraveyardCost
extends CostImpl {
    public ExileOpponentsCardFromExileToGraveyardCost(boolean thatPlayersText) {
        this.text = !thatPlayersText ? "put a card an opponent owns from exile into its owner's graveyard" : "put a card an opponent owns from exile into that player's graveyard";
    }

    public ExileOpponentsCardFromExileToGraveyardCost(ExileOpponentsCardFromExileToGraveyardCost cost) {
        super(cost);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            Card card;
            FilterCard filter = new FilterCard();
            filter.add(TargetController.OPPONENT.getOwnerPredicate());
            TargetCardInExile target = new TargetCardInExile(filter);
            if (controller.chooseTarget(Outcome.Damage, target, ability, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                this.paid = true;
                controller.moveCards(card, Zone.GRAVEYARD, ability, game);
            }
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            for (Card card : game.getExile().getAllCards(game)) {
                if (!controller.hasOpponent(card.getOwnerId(), game)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ExileOpponentsCardFromExileToGraveyardCost copy() {
        return new ExileOpponentsCardFromExileToGraveyardCost(this);
    }
}

