/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPlayer;
import mage.filter.predicate.other.PlayerCanGainLifePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetPlayer;

public class GainLifeOpponentCost
extends CostImpl {
    private static final FilterPlayer filter = new FilterPlayer("opponent that can gain life");
    private final int amount;

    public GainLifeOpponentCost(int amount) {
        this.amount = amount;
        this.text = "an opponent gains " + amount + " life";
    }

    public GainLifeOpponentCost(GainLifeOpponentCost cost) {
        super(cost);
        this.amount = cost.amount;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            for (UUID opponentId : game.getOpponents(controllerId)) {
                Player player = game.getPlayer(opponentId);
                if (player == null || !player.isCanGainLife()) continue;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player opponent;
        TargetPlayer target;
        Player controller = game.getPlayer(controllerId);
        if (controller != null && controller.chooseTarget(Outcome.Detriment, target = new TargetPlayer(1, 1, true, filter), ability, game) && (opponent = game.getPlayer(target.getFirstTarget())) != null) {
            opponent.gainLife(this.amount, game, source);
            this.paid = true;
        }
        return this.paid;
    }

    @Override
    public GainLifeOpponentCost copy() {
        return new GainLifeOpponentCost(this);
    }

    static {
        filter.add(TargetController.OPPONENT.getPlayerPredicate());
        filter.add(new PlayerCanGainLifePredicate());
    }
}

